% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.algorithm.R
\name{select_linkage}
\alias{select_linkage}
\title{Cluster algorithm selection and validation}
\usage{
select_linkage(x)
}
\arguments{
\item{x}{a numeric matrix, data frame or "dist" object.}
}
\value{
\itemize{
  \item A numeric value corresponding to the good clustering algorithm
  for the distance matrix
  \item If plot = TRUE, a barplot of cophenetic correlation for all
  the clustering algorithms is drawn.
}
}
\description{
This function contrasts different hierarchical clustering algorithms
on the phylogenetic beta diversity matrix for degree of
data distortion using Sokal & Rohlf’s (1962) cophenetic
correlation coefficient.
}
\examples{
data(africa)
tree <- africa$phylo
bc <- beta_diss(africa$comm)
y <- select_linkage(bc[[1]])
barplot(y, horiz = TRUE, las = 1)

}
\references{
Sokal, R.R. & Rohlf, F.J. (1962) The comparison of dendrograms by
objective methods. \emph{Taxon} \strong{11}: 33–40.
}
\keyword{bioregion}
