% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecenorm.R
\name{piecenorm}
\alias{piecenorm}
\title{Get piecewse normalised values from a vector of observations}
\usage{
piecenorm(obs, breaks, polarity = 1)
}
\arguments{
\item{obs}{A vector of observations.}

\item{breaks}{The breaks to normalise to.}

\item{polarity}{Which direction should the normalisation occur.}
}
\value{
Vector of normalised observations
}
\description{
Get piecewse normalised values from a vector of observations
}
\examples{
obs <- exp(1:10)
breaks <- c(min(obs), 8, 20, 100, 1000, 25000)
y <- piecenorm(obs, breaks)
plot(obs, y, type = 'l',
xlab = "Original Values",
ylab = "Normalised Values")

}
