% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-geometry.R
\name{AA_to_R}
\alias{AA_to_R}
\alias{R_to_AA}
\alias{geometry_utils}
\alias{R_x}
\alias{R_y}
\alias{R_z}
\alias{to_radians}
\alias{to_degrees}
\alias{to_x}
\alias{to_y}
\alias{to_r}
\alias{to_t}
\title{Helper functions for making geometric calculations.}
\usage{
AA_to_R(angle = 0, axis_x = 0, axis_y = 0, axis_z = NA, ...)

R_to_AA(R = diag(3))

R_x(angle = 0)

R_y(angle = 0)

R_z(angle = 0)

to_radians(t)

to_degrees(t)

to_x(t, r)

to_y(t, r)

to_r(x, y)

to_t(x, y)
}
\arguments{
\item{angle}{Numeric vector in degrees (counter-clockwise) or an \code{\link[affiner:angle]{affiner::angle()}} vector.}

\item{axis_x}{First coordinate of the axis unit vector.}

\item{axis_y}{Second coordinate of the axis unit vector.}

\item{axis_z}{Third coordinate of the axis unit vector (usually inferred).}

\item{...}{Ignored}

\item{R}{3D rotation matrix (post-multiplied)}

\item{t}{Numeric vector in degrees (or radians for \code{to_degrees()}) or an \code{\link[affiner:angle]{affiner::angle()}} vector.}

\item{r}{Radial distance}

\item{x}{Cartesian x coordinate}

\item{y}{Cartesian y coordinate}
}
\description{
\code{to_x}, \code{to_y}, \code{to_r}, \code{to_t} convert
between polar coordinates (in degrees) and Cartesian coordinates.
\code{to_degrees} and \code{to_radians} converts between degrees and radians.
\code{AA_to_R} and \code{R_to_AA} convert back and forth between (post-multiplied) rotation matrix
and axis-angle representations of 3D rotations.
\code{R_x}, \code{R_y}, and \code{R_z} build (post-multiplied) rotation matrices for simple rotations around
the x, y, and z axes.
}
\details{
\code{pp_cfg} uses polar coordinates to determine where the "primary" and "directional"
symbols are located on a game piece.
They are also useful for drawing certain shapes and for making game diagrams on hex boards.

\code{piecepackr} and \code{grid} functions use angles in degrees
but the \code{base} trigonometry functions usually use radians.

\code{piecepackr}'s 3D graphics functions \code{save_piece_obj}, \code{piece}, and \code{piece3d}
use the axis-angle representation for 3D rotations.
The axis-angle representation involves specifying a unit vector
indicating the direction of an axis of rotation and an angle describing the (counter-clockwise)
rotation around that axis.  Because it is a unit vector one only needs to specify the first two elements,
\code{axis_x} and \code{axis_y}, and we are able to infer the 3rd element \code{axis_z}.  The default of
\code{axis = 0}, \code{axis_y = 0}, and implied \code{axis_z = 1}
corresponds to a rotation around the z-axis which is reverse-compatible
with the originally 2D \code{angle} interpretation in \code{grid.piece}.  In order to figure out the appropriate
axis-angle representation parameters \code{R_to_AA}, \code{R_x}, \code{R_y}, and \code{R_z} allow one
to first come up with an appropriate (post-multiplied) 3D rotation matrix by chaining simple rotations
and then convert them to the corresponding axis-angle representation.
Pieces are rotated as if their center was at the origin.
}
\examples{
 to_x(90, 1)
 to_y(180, 0.5)
 to_t(0, -1)
 to_r(0.5, 0)
 all.equal(pi, to_radians(to_degrees(pi)))
 # default axis-angle axis is equivalent to a rotation about the z-axis
 all.equal(AA_to_R(angle=60), R_z(angle=60))
 # axis-angle representation of 90 rotation about the x-axis
 R_to_AA(R_x(90))
 # find Axis-Angle representation of first rotating about x-axis 180 degrees
 # and then rotating about z-axis 45 degrees
 R_to_AA(R_x(180) \%*\% R_z(45))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Axis-angle_representation} for more details
about the Axis-angle representation of 3D rotations.
See \code{\link[base]{Trig}} for R's built-in trigonometric functions.
}
