% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pieceGrob-grid.R
\name{grid.piece}
\alias{grid.piece}
\alias{pieceGrob}
\title{Draw board game pieces using grid}
\usage{
pieceGrob(
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = pp_cfg(),
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  z = NA,
  angle = 0,
  use_pictureGrob = FALSE,
  width = NA,
  height = NA,
  depth = NA,
  op_scale = 0,
  op_angle = 45,
  default.units = "npc",
  envir = NULL,
  name = NULL,
  gp = NULL,
  vp = NULL,
  ...,
  scale = 1,
  alpha = 1
)

grid.piece(
  piece_side = "tile_back",
  suit = NA,
  rank = NA,
  cfg = pp_cfg(),
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  z = NA,
  angle = 0,
  use_pictureGrob = FALSE,
  width = NA,
  height = NA,
  depth = NA,
  op_scale = 0,
  op_angle = 45,
  default.units = "npc",
  envir = NULL,
  name = NULL,
  gp = NULL,
  draw = TRUE,
  vp = NULL,
  ...,
  scale = 1,
  alpha = 1
)
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector of \code{pp_cfg} objects}

\item{x}{Where to place piece on x axis of viewport}

\item{y}{Where to place piece on y axis of viewport}

\item{z}{z-coordinate of the piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{angle}{Angle (on xy plane) to draw piece at}

\item{use_pictureGrob}{If \code{TRUE} instead of directly returning the grob first
export to (temporary) svg and then re-import as a \code{grImport2::pictureGrob}.
This is useful if drawing pieces really big or small and don't want
to play with re-configuring fontsizes.}

\item{width}{Width of piece}

\item{height}{Height of piece}

\item{depth}{Depth (thickness) of piece.  Has no effect if \code{op_scale} is \code{0}.}

\item{op_scale}{How much to scale the depth of the piece in the oblique projection
(viewed from the top of the board).
\code{0} (the default) leads to an \dQuote{orthographic} projection,
\code{0.5} is the most common scale used in the \dQuote{cabinet} projection,
and \code{1.0} is the scale used in the \dQuote{cavalier} projection.}

\item{op_angle}{What is the angle of the oblique projection?  Has no effect if \code{op_scale} is \code{0}.}

\item{default.units}{A string indicating the default units to use if
'x', 'y', 'width', and/or 'height' are only given as numeric vectors.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{name}{A character identifier (for grid)}

\item{gp}{An object of class \code{'gpar'}.}

\item{vp}{A \code{grid} viewport object (or \code{NULL}).}

\item{...}{Ignored.}

\item{scale}{Multiplicative scaling factor to apply to width, height, and depth.}

\item{alpha}{Alpha channel for transparency.}

\item{draw}{A logical value indicating whether graphics output should be produced.}
}
\value{
A \code{grob} object.  If \code{draw} is \code{TRUE} then as a side effect
will also draw it to the graphics device.
}
\description{
\code{grid.piece} draws board game pieces onto the graphics device.
\code{pieceGrob} is its \code{grid} \code{grob} counterpart.
}
\examples{
   if (require("grid")) {
       draw_pp_diagram <- function(cfg=pp_cfg(), op_scale=0) {
           g.p <- function(...) {
               grid.piece(..., op_scale=op_scale, cfg=cfg, default.units="in")
           }
           g.p("tile_back", x=0.5+c(3,1,3,1), y=0.5+c(3,3,1,1))
           g.p("tile_back", x=0.5+3, y=0.5+1, z=1/4+1/8)
           g.p("tile_back", x=0.5+3, y=0.5+1, z=2/4+1/8)
           g.p("die_face", suit=3, rank=5, x=1, y=1, z=1/4+1/4)
           g.p("pawn_face", x=1, y=4, z=1/4+1/2, angle=90)
           g.p("coin_back", x=3, y=4, z=1/4+1/16, angle=180)
           g.p("coin_back", suit=4, x=3, y=4, z=1/4+1/8+1/16, angle=180)
           g.p("coin_back", suit=2, x=3, y=1, z=3/4+1/8, angle=90)
       }

       # default piecepack, orthogonal projection
       draw_pp_diagram(cfg=pp_cfg())

       # custom configuration, orthogonal projection
       grid.newpage()
       dark_colorscheme <- list(suit_color="darkred,black,darkgreen,darkblue,black",
                            invert_colors.suited=TRUE, border_color="black", border_lex=2)
       traditional_ranks <- list(use_suit_as_ace=TRUE, rank_text=",a,2,3,4,5")
       cfg <- c(dark_colorscheme, traditional_ranks)
       draw_pp_diagram(cfg=pp_cfg(cfg))

       # custom configuration, oblique projection
       grid.newpage()
       cfg3d <- list(width.pawn=0.75, height.pawn=0.75, depth.pawn=1,
                          dm_text.pawn="", shape.pawn="convex6", invert_colors.pawn=TRUE,
                          edge_color.coin="tan", edge_color.tile="tan")
       cfg <- pp_cfg(c(cfg, cfg3d))
       draw_pp_diagram(cfg=pp_cfg(cfg), op_scale=0.5)
   }

}
\seealso{
\code{\link{pmap_piece}} which applies \code{pieceGrob}
over rows of a data frame.
}
