% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmap_piece.R
\name{pmap_piece}
\alias{pmap_piece}
\title{Create graphics using data frame input}
\usage{
pmap_piece(
  .l,
  .f = pieceGrob,
  ...,
  cfg = getOption("piecepackr.cfg"),
  envir = getOption("piecepackr.envir"),
  trans = getOption("piecepackr.trans"),
  draw = TRUE,
  name = NULL,
  gp = NULL,
  vp = NULL
)
}
\arguments{
\item{.l}{A list of vectors, such as a data frame. The length of \code{.l}
determines the number of arguments that \code{.f}
will be called  with. List names will be used if present.}

\item{.f}{Function to be applied to \code{.l} after adjustments to
\code{cfg} and \code{envir} and the application of \code{trans}.
Usually \code{\link[=grid.piece]{grid.piece()}}, \code{\link[=pieceGrob]{pieceGrob()}}, \code{\link[=piece3d]{piece3d()}}, or \code{\link[=piece]{piece()}}.}

\item{...}{Extra arguments to pass to \code{.f}.}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,
a list of \code{pp_cfg} objects,
or a character vector referring to names in \code{envir}
or a character vector referring to object names that
can be retrieved by \code{base::dynGet()}.}

\item{envir}{Environment (or named list) containing configuration list(s).}

\item{trans}{Function to modify \code{.l} before drawing.
Default (\code{NULL}) is to not modify \code{.l}.  \code{op_transform}
can help with using an oblique projection (i.e. \code{op_scale} over 0).}

\item{draw}{A logical value indicating whether graphics output should be produced.}

\item{name}{A character identifier (for grid)}

\item{gp}{An object of class \code{'gpar'}.}

\item{vp}{A \code{grid} viewport object (or \code{NULL}).}
}
\description{
\code{pmap_piece()} operates on the rows of a data frame
applying \code{.f} to each row (usually \code{grid.piece}).
}
\details{
\code{pmap_piece()} differs from \code{purrr::pmap()} in a few ways:
\enumerate{
\item{If \code{cfg} and/or \code{envir} are missing attempts to set reasonable defaults.}
\item{If not \code{NULL} will first apply function \code{trans} to \code{.l}.}
\item{If the output of \code{.f} is a grid grob object then \code{pmap_piece}
will return a \code{gTree} object with
specified \code{name}, \code{gp}, and \code{vp} values and if \code{draw} is true draw it.}
\item{If \code{.l} lacks a \code{name} column or if \code{name} column is non-unique
attempts to generate a reasonable new default \code{name} column
and use that to name the return \code{gTree} children  or \code{list} values.}
}
}
\examples{
  if (require("grid")) {
       dark_colorscheme <- list(suit_color="darkred,black,darkgreen,darkblue,black",
                            invert_colors.suited=TRUE, border_color="black", border_lex=2)
       traditional_ranks <- list(use_suit_as_ace=TRUE, rank_text=",a,2,3,4,5")
       cfg3d <- list(width.pawn=0.75, height.pawn=0.75, depth.pawn=1,
                          dm_text.pawn="", shape.pawn="convex6", invert_colors.pawn=TRUE,
                          edge_color.coin="tan", edge_color.tile="tan")
       cfg <- pp_cfg(c(dark_colorscheme, traditional_ranks, cfg3d))
       grid.newpage()
       df_tiles <- data.frame(piece_side="tile_back", x=0.5+c(3,1,3,1), y=0.5+c(3,3,1,1),
                              suit=NA, angle=NA, z=NA, stringsAsFactors=FALSE)
       df_coins <- data.frame(piece_side="coin_back", x=rep(4:1, 4), y=rep(4:1, each=4),
                              suit=1:16\%\%2+rep(c(1,3), each=8),
                              angle=rep(c(180,0), each=8), z=1/4+1/16, stringsAsFactors=FALSE)
       df <- rbind(df_tiles, df_coins)
       pmap_piece(df, cfg=cfg, op_scale=0.5, default.units="in")
  }
}
\seealso{
\code{\link[=render_piece]{render_piece()}} is a higher-level function that wraps this function.
}
