% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\name{recentAlleleClusters}
\alias{recentAlleleClusters}
\title{Retrieving allele similarity clusters Zenodo archive}
\usage{
recentAlleleClusters(
  doi = "10.5281/zenodo.7401189",
  path,
  get_file = FALSE,
  quite = FALSE
)
}
\arguments{
\item{doi}{The doi for the archive to download. Default is the IGHV set.}

\item{path}{The output folder for saving the archive files. Default is to a temporary directory.}

\item{get_file}{Logical (FALSE by default). Do you want to return the path for the file downloaded.}

\item{quite}{Logical (FALSE by default). Do you want to suppress informative messages}
}
\value{
If get_file is TRUE, the function returns the path to the archive file
}
\description{
A wrapper function for \code{zenodoArchive}, download the most recent allele similarity clusters and thresholds from the zenodo archive.
The clusters and thresholds are based on \url{https://yaarilab.github.io/IGHV_reference_book/}
At the moment only available for human IGHV reference set.
}
\examples{

\donttest{
recentAlleleClusters(doi="10.5281/zenodo.7401189")
}

}
