#' Set-shifting data
#'
#' Higgins et al. (2009) re-analyzed data (Roberts et al., 2007)
#' that included 14 studies evaluating the set-shifting ability
#' in people with eating disorders by using a prediction interval.
#' Standardized mean differences in the time taken to complete
#' Trail Making Test between subjects with eating disorders and
#' healthy controls were collected.
#' Positive estimates indicate impairment in set shifting ability
#' in people with eating disorders.
#'
#' \itemize{
#'   \item \code{y}: Standardized mean difference
#'   \item \code{sigmak}: Standard error
#' }
#'
#' @docType data
#' @keywords datasets
#' @name setshift
#' @usage data(setshift)
#' @format A data frame with 14 rows and 2 variables
#' @references
#' Roberts, M. E., Tchanturia, K., Stahl, D.,
#' Southgate, L., and Treasure, J. (2007).
#' A systematic review and meta-analysis of set-shifting
#' ability in eating disorders. \emph{Psychol Med.}
#' \strong{37}(8): 1075-1084.
#' @references
#' Higgins, J. P. T, Thompson, S. G., Spiegelhalter, D. J. (2009).
#' A re-evaluation of random-effects meta-analysis.
#' \emph{J R Stat Soc Ser A Stat Soc.}
#' \strong{172}(1): 137-159.
NULL


#' Pain data
#'
#' The pain data (Riley et al., 2011; Hauser et al., 2009) included
#' 22 studies comparing the treatment effect of antidepressants on
#' reducing pain in patients with fibromyalgia syndrome.
#' The treatment effects were summarized using standardized mean
#' differences on a visual analog scale for pain between the
#' antidepressant group and control group.
#' Negative estimates indicate the reduction of pain in the
#' antidepressant group.
#'
#' \itemize{
#'   \item \code{y}: Standardized mean difference
#'   \item \code{sigmak}: Standard error
#' }
#'
#' @docType data
#' @keywords datasets
#' @name pain
#' @usage data(pain)
#' @format A data frame with 22 rows and 2 variables
#' @references
#' Hauser, W., Bernardy, K, Uceyler, N., and Sommer, C. (2009).
#' Treatment of fibromyalgia syndrome with antidepressants: a
#' meta-analysis. \emph{JAMA.} \strong{301}(2): 198-209.
#' @references
#' Riley, R. D., Higgins, J. P. T, and Deeks, J. J. (2011).
#' Interpretation of random effects meta-analyses.
#' \emph{BMJ.} \strong{342}: d549.
NULL


#' Systolic blood pressure (SBP) data
#'
#' Riley et al. (2011) analyzed a hypothetical meta-analysis.
#' They generated a data set of 10 studies examining the same
#' antihypertensive drug.
#' Negative estimates suggested reduced blood pressure in the
#' treatment group.
#'
#' \itemize{
#'   \item \code{y}: Standardized mean difference
#'   \item \code{sigmak}: Standard error
#' }
#'
#' @docType data
#' @keywords datasets
#' @name sbp
#' @usage data(sbp)
#' @format A data frame with 10 rows and 2 variables
#' @references
#' Riley, R. D., Higgins, J. P. T, and Deeks, J. J. (2011).
#' Interpretation of random effects meta-analyses.
#' \emph{BMJ.} \strong{342}: d549.
NULL
