% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_url.R
\name{board_url}
\alias{board_url}
\title{Use a vector of URLs as a board}
\usage{
board_url(urls, cache = NULL, use_cache_on_failure = is_interactive())
}
\arguments{
\item{urls}{A named character vector of URLs If the URL ends in a \code{/},
\code{board_url} will look for a \code{data.txt} that provides metadata. The
easiest way to generate this file is to upload a pin directory created by
\code{\link[=board_folder]{board_folder()}}.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{use_cache_on_failure}{If the pin fails to download, is it ok to
use the last cached version? Defaults to \code{is_interactive()} so you'll
be robust to poor internet connectivity when exploring interactively,
but you'll get clear errors when the code is deployed.}
}
\description{
\code{board_url()} lets you build up a board from individual urls. This is
useful because \code{\link[=pin_download]{pin_download()}} and \code{\link[=pin_read]{pin_read()}} will be cached - they'll
only re-download the data if it's changed from the last time you downloaded
it (using the tools of
\href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Caching}{HTTP caching}).
You'll also be protected from the vagaries of the internet; if a fresh
download fails, you'll get the previously cached result with a warning.

\code{board_url()} is read only and does not currently support versions.
}
\examples{
github_raw <- "https://raw.githubusercontent.com/"
board <- board_url(c(
  files = paste0(github_raw, "rstudio/pins-r/master/tests/testthat/pin-files/"),
  rds = paste0(github_raw, "rstudio/pins-r/master/tests/testthat/pin-rds/"),
  raw = paste0(github_raw, "rstudio/pins-r/master/tests/testthat/pin-files/first.txt")
))

board \%>\% pin_read("rds")
board \%>\% pin_browse("rds", local = TRUE)

board \%>\% pin_download("files")
board \%>\% pin_download("raw")
}
\seealso{
Other boards: 
\code{\link{board_folder}()},
\code{\link{board_rsconnect}()}
}
\concept{boards}
