% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_versions.R
\name{pin_versions}
\alias{pin_versions}
\alias{pin_version_delete}
\alias{pin_versions_prune}
\title{List, delete, and prune pin versions}
\usage{
pin_versions(board, name, ...)

pin_version_delete(board, name, version, ...)

pin_versions_prune(board, name, n = NULL, days = NULL, ...)
}
\arguments{
\item{board, name}{A pair of board and pin name. For modern boards,
use \code{board \%>\% pin_versions(name)}. For backward compatibility with the
legacy API, you can also use \code{pin_versions(name)} or
\code{pin_version(name, board)}.}

\item{...}{Additional arguments passed on to methods for a specific board.}

\item{version}{Version identifier.}

\item{n, days}{Pick one of \code{n} or \code{days} to choose how many versions to
keep. \code{n = 3} will keep the last three versions, \code{days = 14} will
keep all the versions created in the 14 days. Regardless of what values you
set, \code{pin_versions_prune()} will never delete the most recent version.}
}
\value{
A data frame with at least a \code{version} column. Some boards may
provided additional data.
}
\description{
\itemize{
\item \code{pin_versions()} lists available versions a pin.
\item \code{pin_versions_prune()} deletes old versions.
\item \code{pin_version_delete()} deletes a single version.
}
}
\examples{
board <- board_temp(versioned = TRUE)

board \%>\% pin_write(data.frame(x = 1:5), name = "df")
board \%>\% pin_write(data.frame(x = 2:6), name = "df")
board \%>\% pin_write(data.frame(x = 3:7), name = "df")

# pin_read() returns the latest version by default
board \%>\% pin_read("df")

# but you can return earlier versions if needed
board \%>\% pin_versions("df")

ver <- pin_versions(board, "df")$version[[1]]
board \%>\% pin_read("df", version = ver)

# delete all versions created more than 30 days ago
board \%>\% pin_versions_prune("df", days = 30)
}
