% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_blocked_dna.R
\name{create_blocked_dna}
\alias{create_blocked_dna}
\title{Create a 'blocked' DNA sequence, which is a sequence
with four equal-sized nucleotide sections}
\usage{
create_blocked_dna(length)
}
\arguments{
\item{length}{number of nucleotides. Must be a multiple of four.}
}
\value{
a string
}
\description{
Create a 'blocked' DNA sequence, which is a sequence
with four equal-sized nucleotide sections
}
\examples{
# Will be acgt
create_blocked_dna(length = 4)
# Will be aaccggtt
create_blocked_dna(length = 8)
}
\seealso{
Use \link{create_mono_nuc_dna} to create
  a mono-nucleotide DNA sequence.
}
\author{
Richèl J.C. Bilderbeek
}
