% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dust.R, R/redust.R
\name{dust}
\alias{dust}
\alias{redust}
\title{Dust Table Construction}
\usage{
dust(object, ..., tidy_df = FALSE, keep_rownames = FALSE,
  glance_foot = FALSE, glance_stats = NULL, col_pairs = 2,
  byrow = FALSE, descriptors = "term", numeric_level = c("term",
  "term_plain", "label"))

redust(x, table, part = c("head", "foot", "interfoot", "body"))
}
\arguments{
\item{object}{An object that has a \code{tidy} method in \code{broom}}

\item{...}{Additional arguments to pass to \code{tidy}}

\item{tidy_df}{When \code{object} is an object that inherits the
\code{data.frame} class, the default behavior is to assume that the
object itself is the basis of the table.  If the summarized table is
desired, set to \code{TRUE}.}

\item{keep_rownames}{Whe \code{tidy_df} is \code{FALSE}, setting
\code{keep_rownames} binds the row names to the data frame as the first
column, allowing them to be preserved in the tabulated output.  This
is only to data frame like objects, as the \code{broom::tidy.matrix} method
performs this already.}

\item{glance_foot}{Arrange the glance statistics for the \code{foot} of the
table. (Not scheduled for implementation until version 0.4.0)}

\item{glance_stats}{A character vector giving the names of the glance statistics
to put in the output.  When \code{NULL}, the default, all of the available
statistics are retrieved.  In addition to controlling which statistics are
printed, this also controls the order in which they are printed.}

\item{col_pairs}{An integer indicating the number of column-pairings for the
glance output.  This must be less than half the total number of columns,
as each column-pairing includes a statistic name and value. See the full
documentation for the unexported function \code{\link{glance_foot}}.}

\item{byrow}{A logical, defaulting to \code{FALSE}, that indicates if the
requested statistics are placed with priority to rows or columns.
See the full documentation for the unexported function \code{\link{glance_foot}}.}

\item{descriptors}{A character vector indicating the descriptors to
be used in the table.  Acceptable inputs are \code{"term"},
\code{"term_plain"}, \code{"label"}, \code{"level"}, and
\code{"level_detail"}.  These may be used in any combination and
any order, with the descriptors appearing in the table from left
to right in the order given.  The default, \code{"term"}, returns
only the term descriptor and is identical to the output provided
by \code{broom::tidy} methods.  See Details for a full explanation
of each option and the Examples for sample output.
See the full documentation for the unexported function \code{\link{tidy_levels_labels}}.}

\item{numeric_level}{A character string that determines which descriptor
is used for numeric variables in the \code{"level_detail"} descriptor
when a numeric has an interaction with a factor.  Acceptable inputs
are \code{"term"}, \code{"term_plain"}, and \code{"label"}.
See the full documentation for the unexported function \code{\link{tidy_levels_labels}}.}

\item{x}{A dust object}

\item{table}{A data frame of similar dimensions of the part being replaced.}

\item{part}{The part of the table to replace with \code{table}}
}
\value{
Returns an object of class \code{dust}
}
\description{
Dust tables consist of four primary components that are
  built together to create a full table.  Namely, the \code{head}, the
  \code{body}, the \code{interfoot}, and the \code{foot}.  Dust tables
  also contain a table-wide attributes \code{border_collapse} and
  \code{longtable} as well as a \code{print_method} element.
}
\details{
The \code{head} object describes what each column of the table
  represents.  By default, the head is a single row, but multi row headers
  may be provided.  Note that multirow headers may not render in markdown
  or console output as intended, though rendering in HTML and LaTeX is
  fairly reliable. In longtables (tables broken over multiple pages),
  the \code{head} appears at the top of each table portion.

  The \code{body} object gives the main body of information.  In long tables,
  this section is broken into portions, ideally with one portion per page.

  The \code{interfoot} object is an optional table to be placed at the
  bottom of longtable portions with the exception of the last portion.  A
  well designed \code{interfoot} can convey to the user that the table
  continues on the next page.

  The \code{foot} object is the table that appears at the end of the
  completed table.  For model objects, it is recommended that the
  \code{\link[broom]{glance}} statistics be used to display model fit
  statistics.

  The \code{border_collapse} object applies to an entire HTML table.  It
  indicates if the borders should form a single line or distinct lines.

  The \code{longtable} object determines how many rows per page are printed.
  By default, all content is printed as a single table.  Using the
  \code{longtable} argument in the \code{\link{sprinkle}} function can change this
  setting.

  The \code{print_method} object determines how the table is rendered when
  the \code{print} method is invoked.  The default is to print to the
  console.
}
\section{Upcoming Developments}{

\itemize{
  \item{dust_part }{A wrapper for extracting objects from a \code{dust}
     object.  This is intended to assist in building custom heads and feet.}
}
}
\examples{
x <- dust(lm(mpg ~ qsec + factor(am), data = mtcars))
x
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link[broom]{tidy}} \code{\link{glance_foot}} \code{\link{tidy_levels_labels}}
}

