% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_html_preserve.R
\name{sprinkle_html_preserve}
\alias{sprinkle_html_preserve}
\alias{sprinkle_html_preserve.default}
\alias{sprinkle_html_preserve.dust_list}
\title{Change the HTML Preserve Property in a Dust Table}
\usage{
sprinkle_html_preserve(x,
  html_preserve = getOption("pixie_html_preserve", TRUE), ...)

\method{sprinkle_html_preserve}{default}(x,
  html_preserve = getOption("pixie_html_preserve", TRUE), ...)

\method{sprinkle_html_preserve}{dust_list}(x,
  html_preserve = getOption("pixie_html_preserve", TRUE), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{html_preserve}{\code{logical(1)} indicating if the table is being produced
in a \code{htmltools::htmlPreserve} environment.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
By default \code{pixiedust} makes use of \code{htmltools::htmlPreserve}
  to prevent certain symbols from rendering in unintended ways based on some 
  not-very-well-understood-by-the-author issues.  This property controls whether
  the preservation is used or not.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{html_preserve} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{html_preserve} is not logical(1).
}
}

\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}, \code{\link[htmltools]{htmlPreserve}}
}
\author{
Benjamin Nutter
}
