% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{is_async}
\alias{is_async}
\title{Checks if a function is async}
\usage{
is_async(fun)
}
\arguments{
\item{fun}{Function.}
}
\value{
Logical scalar, whether \code{fun} is async.
}
\description{
If \code{fun} is not a function, an error is thrown.
}
\details{
Currently, it checks for the \code{async} attribute, which is set by
\code{\link[=async]{async()}}.
}
\examples{
f <- function(x) 42
af <- async(f)
is_async(f)
is_async(af)
f()
synchronise(dx <- af())
dx
}
