% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{when_all}
\alias{when_all}
\title{Deferred value for a set of deferred values}
\usage{
when_all(..., .list = list())
}
\arguments{
\item{...}{Deferred values.}

\item{.list}{More deferred values.}
}
\value{
A deferred value, that is conditioned on all deferred values
in \code{...} and \code{.list}.
}
\description{
Create a deferred value that is resolved when all listed deferred values
are resolved. Note that the error of an input deferred value
triggers the error \code{when_all} as well.
}
\details{
async has auto-cancellation, so if one deferred value errors, the rest
of them will be automatically cancelled.
}
\examples{
\donttest{
## Check that the contents of two URLs are the same
afun <- async(function() {
  u1 <- http_get("https://eu.httpbin.org")
  u2 <- http_get("https://eu.httpbin.org/get")
  when_all(u1, u2)$
    then(function(x) identical(x[[1]]$content, x[[2]]$content))
})
synchronise(afun())
}
}
\seealso{
\code{\link[=when_any]{when_any()}}, \code{\link[=when_some]{when_some()}}
}
