% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-home.R
\name{build_home}
\alias{build_home}
\title{Build home section}
\usage{
build_home(pkg = ".", override = list(), preview = NA,
  quiet = TRUE)
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{quiet}{Set to \code{FALSE} to display output of knitr and
pandoc. This is useful when debugging.}
}
\description{
This function generates the home page, and converts other \code{.md} files
typically found in the package root and in \code{.github/}. It generates the home
page from  \code{index.md} or \code{README.md}, falling back to the description field
in \code{DESCRIPTION} if neither is found. It also builds an authors page
from the \code{DESCRIPTION} and \code{inst/CITATION} (if present) and
a license page, and converts any \code{.md} files found in
}
\section{Sidebar}{

The sidebar is automatically populated with:
\itemize{
\item Development status badges found in \code{README.md}/\code{index.md}. pkgdown
identifies badge paragraphs in two ways:
\itemize{
\item A paragraph starting with \code{<!-- badges: start -->} and ending with
\code{<!-- badges: end -->} as created by \code{usethis::use_readme_md()}. or
\code{usethis::use_readme_rmd()}.
\item The first paragraph, if it only contains images.
}
\item A link for bug reports is added if the \code{BugReports} field in
\code{DESCRIPTION} contains a link. You can use \code{usethis::use_github_links()}
to populate this field.
\item Licensing information if \code{LICENSE}/\code{LICENCE} or \code{LICENSE.md}/\code{LICENCE.md}
files are present.
\item Community information is linked in the side bar using the
\code{.github/CONTRIBUTING.md} and \code{.github/CODE_OF_CONDUCT.md} files,
if present.
\item Extra markdown files in the base directory or in \code{.github/} are copied
to \code{docs/} and converted to HTML.
\item Citation information from a \code{inst/CITATION} file is linked in the side bar
to the \href{https://testthat.r-lib.org/authors.html}{authors page}.
\item Author ORCID identification numbers in the \code{DESCRIPTION} are linked under
"Developers" using the ORCID logo:\preformatted{Authors@R: c(
    person("Hadley", "Wickham", , "hadley@rstudio.com", role = c("aut", "cre"),
      comment = c(ORCID = "0000-0003-4757-117X")
    ),
    person("Jay", "Hesselberth", role = "aut",
      comment = c(ORCID = "0000-0002-6299-179X")
    )
  )
}
}
}

\section{Images and figures}{

If you want to include images in your \code{README.md}, they must be stored
somewhere in the package so that they can be displayed on the CRAN website.
The best place to put them is \code{man/figures}. If you are generating figures
with R Markdown, make sure you set up \code{fig.path} as followed:

\preformatted{
```\{r, include = FALSE\}
knitr::opts_chunk$set(
  fig.path = "man/figures/"
)
```
}
}

\section{Package logo}{

If you have a package logo, you can include it at the top of your README in a
level-one heading:\preformatted{# pkgdown <img src="man/figures/logo.png" align="right" />
}

\code{\link[=init_site]{init_site()}} will also automatically create a favicon set from your package
logo.
}

\section{YAML config - home}{

To tweak the home page, you need a section called \code{home}.

By default, the page title and description are extracted automatically
from the \code{Title} and \code{Description} fields \code{DESCRIPTION} (stripping
single quotes off quoted words). CRAN ensures that these fields don't contain
phrases like "R package" because that's obvious on CRAN. To make your
package more findable with google, it's good practice to override the
\code{title} and \code{description}, thinking about what people might search for:\preformatted{home:
  title: An R package for pool-noodle discovery
  description: >
    Do you love R? Do you love pool-noodles? If so, you might enjoy
    using this package to automatically discover and add pool-noodles
    to your growing collection.
}

(Note the use of YAML's \code{>}; this is a convenient way of writing paragraphs
of text.)

The sidebar links are automatically generated by inspecting the \code{URL} and
\code{BugReports} fields of the \code{DESCRIPTION}. You can add additional links with a
subsection called \code{links}, which should contain a list of \code{text} + \code{href}
elements:\preformatted{home:
  links:
  - text: Link text
    href: http://website.com
}

READMEs usually start with an \code{<h1>} containing the package name. If
that feels duplicative with the package name in the navbar you can
remove it with \code{strip_header: true}:\preformatted{home:
  strip_header: true
}
}

\section{YAML config - authors}{

The "developers" list is populated by the maintainer ("cre"), authors
("aut"), and funder ("fnd") from the \code{DESCRIPTION}. You can modify their
display on the home page by adding a subsection for \code{authors}. The author
name should match the value in \code{DESCRIPTION}:\preformatted{authors:
  name:
    href: "http://name-website.com"
    html: "<img src='name-picture.png' height=24>"
}
}

