% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{download_files_with_md5_mismatch}
\alias{download_files_with_md5_mismatch}
\title{Download files marked as mismatch to package cache.}
\usage{
download_files_with_md5_mismatch(
  local_files_absolute,
  local_files_md5_ok,
  urls,
  files_are_binary = NULL
)
}
\arguments{
\item{local_files_absolute, }{vector of strings. A vector of filenames, must already include the package cache part.}

\item{local_files_md5_ok, }{logical vector. For each file, whether the local copy is OK. Only files for which this lists FALSE will be downloaded.}

\item{urls, }{vector of strings. For each file, a remote URL where to download the file. Will be passed to `downloader::download`, see that function for URL encoding details.}

\item{files_are_binary, }{logical vector. For each file, whether it is binary. Only required on Windows, when files need to be downloaded. See `downloader::download` docs for details.}
}
\description{
Download files marked as mismatched to package cache. You should check afterwards whether this was successful, e.g., via `files_exist_md5`.
}
\keyword{internal}
