% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{unpack}
\alias{unpack}
\title{Unpack packages from a text file}
\usage{
unpack(input, output = ".", install = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{input}{Path to the text file.}

\item{output}{Path to the output directory.
Each package is placed under a subdirectory named after the package name.
Default is the current working directory.}

\item{install}{Try install the unpacked package(s)?}

\item{quiet}{Suppress printing of progress?}

\item{...}{Additional parameters for \code{\link[remotes:install_local]{remotes::install_local()}}.}
}
\value{
The output directory path.
}
\description{
Unpack packages from a text file
}
\details{
If \code{install = TRUE}, the packages will be installed by the order of
appearance in the \code{input} file. When internal dependencies exist between
these packages, make sure they are packed in the order where the
low-level dependencies appear first.
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Read input file.
    \item Construct output file paths.
    \item Write all files in all packages to their destination in
    the order of their appearance in the input file.
    \item Install the unpacked packages if \code{install = TRUE}.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# pack two packages
pkg1 <- system.file("examples/pkg1", package = "pkglite")
pkg2 <- system.file("examples/pkg2", package = "pkglite")

fc1 <- pkg1 \%>\% collate(file_default())
fc2 <- pkg2 \%>\% collate(file_default())

txt <- tempfile(fileext = ".txt")
pack(fc1, fc2, output = txt, quiet = TRUE)

# unpack the two packages
out <- file.path(tempdir(), "twopkgs")
txt \%>\% unpack(output = out, quiet = TRUE)

out \%>\%
  file.path("pkg1") \%>\%
  list.files()
out \%>\%
  file.path("pkg2") \%>\%
  list.files()
}
