% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devutils.R
\name{packageData}
\alias{packageData}
\alias{ldata}
\title{Loading Package Data}
\usage{
packageData(list, envir = .GlobalEnv, ..., options = NULL,
  stringsAsFactors = getOption("stringsAsFactors", TRUE))

ldata(list, ...)
}
\arguments{
\item{list}{character vector containing the names of the data to load.}

\item{envir}{the \link{environment} where the data should be loaded.}

\item{...}{other arguments eventually passed to \code{\link[utils]{data}}.}

\item{options}{list of R options to set before calling \code{\link[utils]{data}}.
This may be useful the data is shipped as an R script.}

\item{stringsAsFactors}{logical that indicates if character columns of tabular data should be
converted into factors.}
}
\value{
the loaded data.
}
\description{
Loads package data using \code{\link[utils]{data}}, but allows the user to avoid
NOTEs for a \sQuote{non visible binding variable} to be thrown when checking a package.
This is possible because this function returns the loaded data.
}
\section{Functions}{
\itemize{
\item \code{ldata}: loads a package data in the parent frame.
It is a shortcut for \code{packageData(list, ..., envir=parent.frame())}.
}}

\examples{
\dontshow{
options(R_CHECK_RUNNING_EXAMPLES_=TRUE) ## roxygen generated flag
}


\dontrun{ mydata <- packageData('mydata') }


\dontrun{ 
# in a package' source => won't issue a NOTE
myfunction function(){
	mydata <- ldata('mydata') 
}
}

}
