% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{new2}
\alias{new2}
\title{Alternative S4 Constructor}
\usage{
new2(class, ...)
}
\arguments{
\item{class}{Class name to instanciate}

\item{...}{extra arguments from which slot values are extracted by exact
matching of names.}
}
\value{
An S4 object.
}
\description{
An alternative version of \code{\link{new}} to create objects based on a list
of values.
}
\examples{

setClass('A', contain='character', representation(x='numeric', y='character'))

# identical behaviour with standard calls
identical(new('A'), new2('A'))
identical(new('A', x=1), new2('A', x=1))

# but if passing that are names not slots 
identical(new('A'), new2('A', b=1))
identical(new('A', x=1), new2('A', x=1, b=3))
identical(new('A', x=1), new2('A', x=1, b=3))

# standard `new` would coerce first unnamed argument into parent of 'A' (i.e. 'character') 
new('A', list(x=1))
new('A', list(x=1, y='other'))
# `new2` rather use it to initialise the slots it can find in the list 
identical(new('A', x=1), new2('A', list(x=1)))
identical(new('A', x=1, y='other'), new2('A', list(x=1, y='other')))


}
