\name{repair_docu}
\alias{repair_docu}
\alias{repair_docu.Rd}
\alias{repair_docu.character}
\title{Repair Rd files}
\usage{
  repair_docu(x, ...)

  \method{repair_docu}{character} (x, ignore = NULL, ...)

  \method{repair_docu}{Rd} (x, remove.dups = FALSE, ...)
}
\arguments{
  \item{x}{Object of class \sQuote{Rd}, or name(s) of Rd
  file(s) or of one to several package directories. See
  \code{\link{pkg_files}} for the possible expansion of
  names.}

  \item{remove.dups}{Logical scalar indicating whether
  (probably) duplicate links in the \sQuote{seealso}
  section shall be removed.}

  \item{...}{Optional arguments passed to and from other
  methods, or between the methods.}

  \item{ignore}{\code{NULL} or a character vector of file
  names (without their directory-name parts) to remove from
  the result. Matching is done case- insensitively. Ignored
  if empty.}
}
\value{
  The \sQuote{Rd} method returns an object of class
  \sQuote{Rd}, the character method a list of such objects,
  invisibly.
}
\description{
  Repair some sometimes encountered, minor problems in Rd
  files generated by \pkg{roxygen2} (but not those related
  to S4 methods), and run the checks implemented in
  \code{\link{check_keywords}} and
  \code{\link{check_examples}}.
}
\examples{
data(xyplot.docu)
summary(x <- repair_docu(xyplot.docu))
stopifnot(identical(x, xyplot.docu)) # nothing to repair here
}
\seealso{
  Other rd-functions: \code{\link{check_examples}},
    \code{\link{check_keywords}},
        }
\keyword{package}

