% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burndown.R
\name{as.burndown}
\alias{as.burndown}
\title{Create a burndown object}
\usage{
as.burndown(start, deadline, tasks, progress, progressInPercent = FALSE)
}
\arguments{
\item{start}{Start date}

\item{deadline}{Deadline (end date)}

\item{tasks}{Data frame containing the task IDs (may be alphanumeric), their description and effort}

\item{progress}{Data frame containing the progress values with task ID, timestamp and work done (either in percentage or absolute)}

\item{progressInPercent}{boolean; if set to \code{FALSE}, progress values are treated like absolute values and
converted to percentages}
}
\value{
A burndown object.
}
\description{
Create a \linkS4class{burndown} object from the given data.
}
\details{
Creates a \linkS4class{burndown} object from the given data; progress may be given in percentage or absolute values.
}
\examples{
library(plan)
# same data as in tests/burndown.dat
start <- as.POSIXct(strptime("2006-04-08 12:00:00", "\%Y-\%m-\%d \%H:\%M:\%S"))
deadline <- as.POSIXct(strptime("2006-04-11 20:00:00", "\%Y-\%m-\%d \%H:\%M:\%S"))
tasks <- data.frame(key = c(1, 2, 3, 4, 5, 6),
                    description = c("code read.burndown()", "code summary.burndown()", 
                                    "code plot.burndown()", "create R package", 
                                    "write documentation", "set up website"),
                    effort = c(4, 1, 5, 2, 2, 1),
                    stringsAsFactors = FALSE)
progress <- data.frame(key = c(1, 2, 1, 2, 4, 5, 4, 1, 3, 3, 3, 2, 2, 1, 5, 5, 5, 1, 3, 6),
                       progress = c(5, 5, 10, 50, 5, 5, 100, 50, 5, 30, 80, 60, 
                                    100, 70, 30, 90, 100, 100, 100, 100),
                       time = structure(c(1144494000, 1144495800, 1144497600, 1144501200, 
                                          1144517400, 1144519200, 1144523760, 1144566600, 
                                          1144568460, 1144570680, 1144573200, 1144576800, 
                                          1144577400, 1144578600, 1144583400, 1144585200,
                                          1144585800, 1144586100, 1144586400, 1144591200), 
                                          class = "POSIXct"),
                       stringsAsFactors = FALSE
                       )
b <- as.burndown(start, deadline, tasks, progress, progressInPercent = TRUE)
summary(b)
plot(b)
}
\seealso{
Other things related to burndown data: 
\code{\link{burndown-class}},
\code{\link{burndown}},
\code{\link{plot,burndown-method}},
\code{\link{read.burndown}()},
\code{\link{summary,burndown-method}}
}
\author{
Frank Schmitt
}
\concept{things related to burndown data}
