% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.plasso.R
\name{summary.cv.plasso}
\alias{summary.cv.plasso}
\title{Summary of cross-validated (Post-) Lasso model}
\usage{
\method{summary}{cv.plasso}(object, ..., default = FALSE)
}
\arguments{
\item{object}{\code{\link{cv.plasso}} object}

\item{...}{Pass generic \code{\link[base]{summary}} summary options}

\item{default}{TRUE for \code{\link[glmnet]{glmnet}}-like summary output, FALSE for more specific summary information}
}
\value{
For specific summary information: summary.cv.plasso object (using list structure) containing optimal
lambda values and associated MSEs for both cross-validated Lasso and Post-Lasso model.
For default: \code{\link[base:summary]{summaryDefault}} object.
}
\description{
Summary of cross-validated (Post-) Lasso model.
}
\examples{
# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit cv.plasso to the data
\donttest{p.cv = plasso::cv.plasso(X,y)}
# get informative summary statistics
\donttest{print(summary(p.cv, default=FALSE))}
# set default=TRUE for standard summary statistics
\donttest{print(summary(p.cv, default=TRUE))}

}
