% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_grid.R
\name{pc_grid}
\alias{pc_grid}
\title{Plots multiple platemaps as a heatmap of the first principal component.}
\usage{
pc_grid(data, well, plate_id, ncols = 2, plate = 96, ...)
}
\arguments{
\item{data}{Numerical values be transformed, scaled and plotted as a colour}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate_id}{Vector of plate labels or identifiers e.g "plate_1"}

\item{ncols}{Number of columns to plot multiple platemaps}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}

\item{...}{additional arguments to be passed to z_grid}
}
\value{
ggplot plot
}
\description{
Converts multivariate data and well labels into a heatmap of the first
principal component in the form of a grid of platemaps.
}
\examples{
df01 <- data.frame(
  well = num_to_well(1:96),
  plate = 1,
  vals1 = rnorm(1:96),
  vals2 = rnorm(1:96))

df02 <- data.frame(
  well = num_to_well(1:96),
  plate = 2,
  vals1 = rnorm(1:96),
  vals2 = rnorm(1:96))

df <- rbind(df01, df02)

pc_grid(data = df[, 3:4],
    well = df$well,
    plate_id = df$plate,
    plate = 96)
}

