% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_wells.R
\name{missing_wells}
\alias{missing_wells}
\title{Returns wells that are missing from a complete plate}
\usage{
missing_wells(df, well, plate = 96)
}
\arguments{
\item{df}{dataframe}

\item{well}{Column containing well identifiers i.e "A01"}

\item{plate}{Number of wells in complete plate (96 or 384)}
}
\value{
vector of missing wells
}
\description{
Returns a vector of wells that are missing from a complete plate.
}
\examples{
vals <- rnorm(96) ; wells <- num_to_well(1:96)
df <- data.frame(vals, wells)
df_missing <- df[-c(1:10), ]
missing_wells(df_missing, "wells")
}
