library(deSolve)
source("IndusChemFate.R")

params <- c(
  # PHYSIOLOGICAL PARAMS
  # HUMAN TISSUE VOLUMES (FRACTION OF BODY WEIGHT)
  BODYWT = 70.0         ,# KG; BODY WEIGHT
  FRART = 0.3          ,# DIMENSIONLESS; FRACTION ARTERIAL BLOOD
  FRVEN = 0.7          ,# DIMENSIONLESS; FRACTION VENOUS BLOOD
  VOLBLOODC = 0.0832       ,# DIMENSIONLESS; BLOOD
  VOLADIPC = 0.1841       ,# DIMENSIONLESS; ADIPOSE ADDED .0001 TO CORRECT MASS BALANCE.
  VOLBONEC = 0.0589       ,# DIMENSIONLESS; BONE
  VOLBRAINC = 0.0192       ,# DIMENSIONLESS; BRAIN
  VOLHEARTC = 0.0051       ,# DIMENSIONLESS; HEART
  VOLKIDNEYC = 0.0046       ,# DIMENSIONLESS; KIDNEY
  VOLINTESTC = 0.0222       ,# DIMENSIONLESS; INTESTINE
  VOLLIVERC = 0.0225       ,# DIMENSIONLESS; LIVER
  VOLLUNGSC = 0.0144       ,# DIMENSIONLESS; LUNGS
  VOLMUSCLEC = 0.4576       ,# DIMENSIONLESS; MUSCLE
  VOLSKINC = 0.0553       ,# DIMENSIONLESS; SKIN
  VOLMARROWC = 0.0729       ,# DIMENSIONLESS; MARROW
  TOTSKIN = 18000.0      ,# CM^2; BODY SURFACE AREA
  SKINFAC = 1            ,# DIMENSIONLESS; SKIN PERMEABILITY RATIO
  URINFLOW = 0.0214       ,# LITRE/KGBW/DAY; URINARY FLOW RATE
  GLOMFILTR = 0.08         ,# DIMENSIONLESS; FRACTION OF RENAL ARTERIAL FLOW
  FRWSOL = 1,
  REMOVKDN = 0.2,
  # HUMAN BLOOD FLOWS (FRACTION OF CARDIAC OUTPUT)
  CARDOUTPC = 6.0          ,# L/HR-KG; CARDIAC OUTPUT
  ALVVENTC = 7.0          ,# L/HR-KG; TOTAL PULMONARY VENTILATION
  FRADIPC = 0.08226      ,# DIMENSIONLESS; ADIPOSE
  FRBONEC = 0.04139      ,# DIMENSIONLESS; BONE
  FRBRAINC = 0.09814      ,# DIMENSIONLESS; BRAIN
  FRHEARTC = 0.10536      ,# DIMENSIONLESS; HEART
  FRKIDNEYC = 0.16886      ,# DIMENSIONLESS; KIDNEY
  FRLIVVENC = 0.1524       ,# DIMENSIONLESS; LIVER VENOUS ADDED .0004 TO CORRECT MASS BALANCE.
  FRLIVARTC = 0.0381       ,# DIMENSIONLESS; LIVER ARTERIAL
  FRLUNGC = 0.0234       ,# DIMENSIONLESS; LUNG
  FRMUSCLEC = 0.13711      ,# DIMENSIONLESS; MUSCLE
  FRSKINC = 0.06783      ,# DIMENSIONLESS; SKIN
  FRMARROWC = 0.08515      ,# DIMENSIONLESS; MARROW
  
  # PARTITION cOEFFS
  PMUSCLE = 1,
  PBONE = 1,
  PMARROW = 1,
  PSTOM = 1,
  PKIDNEY = 1,
  PBRAIN= 1,
  PHEART = 1,
  PLUNG = 1,
  PADIP= 1,
  PSKIN =1,
  PLIVER = 1,
  RCBA = 1,
  DecrBolusRt = 0.1,
  VMAX = 1,
  KM = 0.1,
  
  PDOSE = 0.6
)

state <- c(AMUSCLE=0.0,
  AEXH=0.0,
  ABRAIN=0.0,
  AEXC=0.0,
  ALIVER=0.0,
  ABONE=0.0,
  ALUNG=0.0,
  ASKIN=0.0,
  AMARROW=0.0,
  AINH=0.0,
  AVEN=0.0,
  URINVOL=0.005,
  AADIPOSE=0.0,
  AKIDNEY=0.0,
  ASTOM=0.0,
  AMET=0.0,
  TOTDOSE =0.0,
  DOSE=0.0,
  AART=0.0,
  AHEART=0.0,
  AUCMUSCLE=0.0,
  AUCBRAIN=0.0,
  AUCLIVER=0.0,
  AUCBONE=0.0,
  AUCLUNG=0.0,
  AUCSKIN=0.0,
  AUCMARROW=0.0,
  AUCVEN=0.0,
  AUCADIPOSE=0.0,
  AUCKIDNEY=0.0,
  AUCSTOM=0.0,
  AUCART=0.0,
  AUCHEART=0.0
)

eventfun<- function(t,y,parms){
  with (as.list(c(y,parms)),{
    DOSE<- DOSE+(PDOSE*BODYWT)
    TOTDOSE<- TOTDOSE+(PDOSE*BODYWT)
    return(c(AMUSCLE,AEXH,ABRAIN,AEXC,ALIVER,ABONE,ALUNG,ASKIN,AMARROW,AINH,AVEN,URINVOL,AADIPOSE,AKIDNEY,ASTOM,AMET,TOTDOSE,DOSE,AART,AHEART,
             AUCMUSCLE,AUCBRAIN,AUCLIVER,AUCBONE,AUCLUNG,AUCSKIN,AUCMARROW,AUCVEN,AUCADIPOSE,AUCKIDNEY,AUCSTOM,AUCART,AUCHEART))
  })
}

t_start <- 0
t_dur <- 240
times <- seq(t_start,t_dur,by=0.1)
 
evnt_times <- seq(0,t_dur,24)

modelOutput<- ode(y = state, times = times,
                  func = icfModel, parms = params,
                  events = list(func = eventfun,time = evnt_times))
