\name{lpredprob.GP}
\alias{lpredprob.GP}
\alias{lpredprob.CGP}
\alias{lpredprob.ConstGP}
\title{
  Log-Predictive Probability Calculation for GPs
}
\description{
  Log-predictive probability calculation for Gaussian process (GP)
  regression, classification, or combined unknown constraint
  models; primarily to be used particle learning (PL) re-sample step
}
\usage{
lpredprob.GP(z, Zt, prior)
lpredprob.CGP(z, Zt, prior)
lpredprob.ConstGP(z, Zt, prior)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{z}{
    new observation whose (log) predictive probability is to be
    calculated given the particle \code{Zt}
  }
  \item{Zt}{
    the particle describing model parameters and sufficient statistics
    that determines the predictive distribution
  }
  \item{prior}{
    prior parameters passed from \code{\link{PL}} generated by one of
    the prior functions, e.g., \code{\link{prior.GP}}
  }
}
\details{
  This is the workhorse of the \code{\link{PL}} re-sample step.  For
  each new observation (in sequence), the
  \code{\link{PL}} function calls \code{lpredprob} and these values
  determine the weights used in the \code{\link{sample}} function to
  obtain the new particle set, which is then propagated, e.g., using
  \code{\link{propagate.GP}}

  The \code{\link{lpredprob.ConstGP}} is essentially the combination
  (product) of \code{\link{lpredprob.GP}} and
  \code{\link{lpredprob.CGP}} for regression and classification GP
  models, respectively
}
\value{
  Returns a real-valued scalar - the log predictive probability
}
\references{
   Gramacy, R. and Polson, N. (2010).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Tech. Rep. arXiv:0909.5262, University of Cambridge.

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  \url{http://www.statslab.cam.ac.uk/~bobby/plgp.html}
}
\author{
Robert B. Gramacy, \email{bobby@statslab.cam.ac.uk}
}

\seealso{
  \code{\link{PL}}, \code{\link{propagate.GP}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}
\keyword{models}
\keyword{regression}
\keyword{methods}
