% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{palettes}
\alias{palettes}
\alias{image_palette}
\title{Create image palettes}
\usage{
image_palette(img, npal = 5, proportional = TRUE, plot = TRUE)
}
\arguments{
\item{img}{An image object.}

\item{npal}{The number of color palettes.}

\item{proportional}{Creates a joint palette with proportional size equal to
the number of pixels in the image? Defaults to \code{TRUE}.}

\item{plot}{Plot the generated palette? Defaults to \code{TRUE}.}
}
\value{
\code{image_palette()} returns a list with two elements:
\itemize{
\item \code{palette_list} A list with \code{npal} color palettes of class \code{Image}.
\item \code{joint} An object of class \code{Image} with the color palettes
\item \code{proportions} The proportion of the entire image corresponding to each color in the palette
\item \code{rgbs} The average RGB value for each palette
}
}
\description{
\code{image_palette()}  creates image palettes by applying the k-means algorithm
to the RGB values.
}
\examples{
\donttest{
library(pliman)
img <- image_pliman("sev_leaf.jpg")
pal <- image_palette(img, npal = 4)

image_combine(pal$palette_list)

}
}
