% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{plot_index_shp}
\alias{plot_index_shp}
\title{Plot rectangles colored by a quantitative attribute and overlay on an RGB
image}
\usage{
plot_index_shp(
  object,
  attribute = "coverage",
  color = c("red", "green"),
  viewer = c("mapview", "base"),
  max_pixels = 5e+05,
  downsample = NULL,
  downsample_fun = NULL,
  alpha = 0.5,
  legend.position = "bottom",
  na.color = "gray",
  classes = 6,
  round = 3,
  horiz = TRUE
)
}
\arguments{
\item{object}{An object computed with \code{\link[=analyze_objects_shp]{analyze_objects_shp()}}.}

\item{attribute}{The name of the quantitative variable in the
\code{object_index} to be used for coloring the rectangles.}

\item{color}{A vector of two colors to be used for the color scale.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are \code{"base"} and
\code{"mapview"}. If set to "base", the base R graphics system is used for
interactive plotting. If set to "mapview", the mapview package is used. To
set this argument globally for all functions in the package, you can use
the \code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{max_pixels}{integer > 0. Maximum number of cells to plot the index. If
\code{max_pixels < npixels(img)}, downsampling is performed before plotting the
index. Using a large number of pixels may slow down the plotting time.}

\item{downsample}{integer; for each dimension the number of
pixels/lines/bands etc that will be skipped; Defaults to \code{NULL}, which will
find the best downsampling factor to approximate the \code{max_pixels} value.}

\item{downsample_fun}{function; if given, downsampling will apply
\verb{downsample_fun`` } to each of the the subtiles.}

\item{alpha}{The transparency level of the rectangles' color (between 0 and 1).}

\item{legend.position}{The position of the color legend, either
\code{"bottom"} or \code{"right"}.}

\item{na.color}{The color to be used for rectangles with missing values in
the quantitative variable.}

\item{classes}{The number of classes in the color scale.}

\item{round}{The number of decimal places to round the legend values.}

\item{horiz}{Logical, whether the legend should be horizontal (\code{TRUE})
or vertical (\code{FALSE}).}
}
\value{
The function plots rectangles colored by the specified quantitative
variable on top of the RGB image and shows the continuous color legend
outside the plot.
}
\description{
This function plots rectangles on top of an RGB image, where each rectangle
is colored based on a quantitative variable. The quantitative variable is
specified in the \code{attribute} argument and should be present in the
\code{object_index} of the \code{object} computed using \code{\link[=analyze_objects_shp]{analyze_objects_shp()}}. The
rectangles are colored using a color scale.
}
\examples{
if(interactive()){
library(pliman)

# Computes the DGCI index for each flax leaf
flax <- image_pliman("flax_leaves.jpg", plot =TRUE)
res <-
   analyze_objects_shp(flax,
                       buffer_x = 0.2,
                       buffer_y = 0.2,
                       nrow = 3,
                       ncol = 5,
                       plot = FALSE,
                       object_index = "DGCI")
plot(res$final_image)
plot_index_shp(res)
}

}
