% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_fun_to_imgs.R
\name{apply_fun_to_imgs}
\alias{apply_fun_to_imgs}
\title{Apply a function to images}
\usage{
apply_fun_to_imgs(
  pattern,
  fun,
  ...,
  dir_original = NULL,
  dir_processed = NULL,
  prefix = "",
  suffix = "",
  parallel = FALSE,
  workers = 3,
  verbose = TRUE
)
}
\arguments{
\item{pattern}{A pattern to match the images' names.}

\item{fun}{A function to apply to the images.}

\item{...}{Arguments passed on to \code{fun}.}

\item{dir_original, dir_processed}{The directory containing the original and processed
images. Defaults to \code{NULL}, which means that the current working directory will be
considered. \strong{The processed image will overwrite the original image unless a
prefix/suffix be used or a subfolder is informed in dir_processed argument}.}

\item{prefix, suffix}{A prefix and/or suffix to be included in the name of processed
images. Defaults to \code{""}.}

\item{parallel}{If \code{TRUE} processes the images asynchronously (in parallel) in separate
R sessions (3 by default) running in the background on the same machine. It may speed
up the processing time, especially when pattern is used is informed.}

\item{workers}{A positive numeric scalar or a function specifying the number of
parallel processes that can be active at the same time. Defaults to 3.}

\item{verbose}{Shows the progress in console? Defaults to \code{TRUE}.}
}
\value{
Nothing. The processed images are saved to the current working directory.
}
\description{
Most of the functions in pliman can be applied to a list of images, but this can be not
ideal to deal with lots of images, mainly if they have a high resolution. For
curiosity, a 6000 x 4000 image use nearly 570 Megabytes of RAM. So, it would be
impossible to deal with lots of images within R. \code{apply_fun_to_img()} applies a
function to images stored in a given directory as follows:
\itemize{
\item Create a vector of image names that contain a given pattern of name.
\item Import each image of such a list.
\item Apply a function to the imported image.
\item Export the mutated image to the computer.
}

If parallel is set to \code{FALSE} (default), the images are processed sequentially, which
means that one image needs to be imported, processed, and exported so that the other
image can be processed. If parallel is set to \code{TRUE},  the images are processed
asynchronously (in parallel) in separate R sessions (3) running in the background on
the same machine. It may speed up the processing time when lots of images need to be
processed.
}
\examples{
# apply_fun_to_imgs("pattern", image_resize, rel_size = 50)
}
