% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_view}
\alias{mosaic_view}
\title{Mosaic View}
\usage{
mosaic_view(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  edit = FALSE,
  title = "",
  shapefile = NULL,
  attribute = NULL,
  viewer = c("mapview", "base"),
  show = c("rgb", "index"),
  index = "B",
  max_pixels = 1e+06,
  downsample = NULL,
  downsample_fun = "nearest",
  alpha = 1,
  quantiles = c(0, 1),
  color_regions = custom_palette(c("red", "yellow", "forestgreen")),
  axes = FALSE,
  ...
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r, g, b}{The layer for the Red, Green and Blue band, respectively.
Defaults to \code{1}, \code{2}, and \code{3}.}

\item{edit}{If \code{TRUE} enable editing options using \code{\link[mapedit:editMap]{mapedit::editMap()}}.}

\item{title}{A title for the generated map or plot (default: "").}

\item{shapefile}{An optional shapefile of class \code{sf} to be plotted over the
mosaic. It can be, for example, a plot-level result returned by
\code{\link[=mosaic_analyze]{mosaic_analyze()}}.}

\item{attribute}{The attribute name(s) or column number(s) in shapefile table
of the column(s) to be rendered.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{downsample_fun}{The resampling function. Defaults to nearest. See further details in \code{\link[=mosaic_aggregate]{mosaic_aggregate()}}.}

\item{alpha}{opacity of the fill color of the raster layer(s).}

\item{quantiles}{the upper and lower quantiles used for color stretching.}

\item{color_regions}{The color palette for displaying index values. Default
is \code{\link[=custom_palette]{custom_palette()}}.}

\item{axes}{logical. Draw axes? Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed on to \code{\link[terra:plot]{terra::plot()}} when \code{viewer = "base"}.}
}
\value{
An sf object, the same object returned by \code{\link[mapedit:editMap]{mapedit::editMap()}}.
}
\description{
Mosaic View
}
\details{
The function can generate either an interactive map using the 'mapview'
package or a static plot using the 'base' package, depending on the \code{viewer}
and \code{show} parameters. If show = "index" is used, the function first computes
an image index that can be either an RGB-based index or a multispectral
index, if a multispectral mosaic is provided.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
# Load a raster showing the elevation of Luxembourg
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))

# Generate an interactive map using 'mapview'
mosaic_view(mosaic)

# Generate a static plot using 'base'
mosaic_view(mosaic, viewer = "base")
}


}
