% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{image_prepare}
\alias{image_prepare}
\title{Prepare an image}
\usage{
image_prepare(
  img,
  viewer = get_pliman_viewer(),
  downsample = NULL,
  max_pixels = 1e+06
)
}
\arguments{
\item{img}{An optional \code{Image} object}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{downsample}{integer; for each dimension the number of
pixels/lines/bands etc that will be skipped; Defaults to \code{NULL}, which will
find the best downsampling factor to approximate the \code{max_pixels} value.}

\item{max_pixels}{integer > 0. Maximum number of cells to use for the plot.
If \code{max_pixels < npixels(img)}, regular sampling is used before plotting.}
}
\value{
The alighed/cropped image for further visualization or analysis.
}
\description{
This function aligns and crops the image using either base or mapview
visualization. This is useful to prepare the images to be analyzed with
\code{\link[=analyze_objects_shp]{analyze_objects_shp()}}
}
\examples{
# Example usage:
if (interactive() && requireNamespace("EBImage")) {
img <- image_pliman("mult_leaves.jpg")
image_prepare(img, viewer = "mapview")
}
}
