% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_predictors.R
\name{add_predictors}
\alias{add_predictors}
\title{A helper function to add predictors to a filebacked matrix of data}
\usage{
add_predictors(obj, add_predictor, id_var, rds_dir, quiet)
}
\arguments{
\item{obj}{A \code{bigSNP} object}

\item{add_predictor}{Optional: add additional covariates/predictors/features from an external file (i.e., not a PLINK file).}

\item{id_var}{String specifying which column of the PLINK \code{.fam} file has the unique sample identifiers.}

\item{rds_dir}{The path to the directory in which you want to create the new '.rds' and '.bk' files. Defaults to \code{data_dir}(from \code{process_plink()} call)}

\item{quiet}{Logical: should messages be printed to the console? Defaults to FALSE (which leaves the print messages on...)}
}
\value{
A list of 2 components:
\itemize{
\item 'obj' - a \code{bigSNP} object with an added element representing the matrix that includes the additional predictors as the first few columns
\item 'non_gen' - an integer vector that ranges from 1 to the number of added predictors. Example: if 2 predictors are added, unpen= 1:2
}
}
\description{
A helper function to add predictors to a filebacked matrix of data
}
\keyword{internal}
