% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{check_normaldist}
\alias{check_normaldist}
\title{Compare distribution of data with normal distribution.}
\usage{
check_normaldist(res, col = "red", col.normal = "black",
  legend.pos = "topright", legend.label = "data", ...)
}
\arguments{
\item{res}{Vector with residuals or other data for which the distribution .}

\item{col}{Color for filling the area. Default is black.}

\item{col.normal}{Color for shading and line of normal distribution.}

\item{legend.pos}{Position of legend, can be string (e.g., 'topleft') or an 
\code{\link[grDevices]{xy.coords}} object.}

\item{legend.label}{Text string, label for plotted data distribution.}

\item{...}{Optional arguments for the lines. See \code{\link{par}}.}
}
\description{
Compare distribution of data with normal distribution.
}
\section{Note}{

Assumes centered data as input.
}
\examples{
set.seed(123)
# normal distribution:
test <- rnorm(1000)
check_normaldist(test)
# t-distribution:
test <- rt(1000, df=5)
check_normaldist(test)
# skewed data, e.g., reaction times:
test <- exp(rnorm(1000, mean=.500, sd=.25))
check_normaldist(test)
# center first:
check_normaldist(scale(test))
# binomial distribution:
test <- rbinom(1000, 1, .3)
check_normaldist(test)
# count data:
test <- rbinom(1000, 100, .3)
check_normaldist(test)
}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

