% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefractionplot.R
\name{RarefactionPlotAtomic}
\alias{RarefactionPlotAtomic}
\title{RarefactionPlotAtomic}
\usage{
RarefactionPlotAtomic(
  data,
  type = 1,
  se = TRUE,
  group_by = "group",
  group_name = NULL,
  pt_size = 3,
  line_width = 1,
  theme = "theme_this",
  theme_args = list(),
  palette = "Spectral",
  palcolor = NULL,
  alpha = 0.2,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{data}{An iNEXT object or a list of data that will be handled by \link[iNEXT:iNEXT]{iNEXT::iNEXT}.}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1});
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{se}{a logical variable to display confidence interval around the estimated sampling curve.
Default to \code{NULL} which means TRUE if the data has the lower and upper bounds.}

\item{group_by}{A character string indicating how to group the data (color the lines).
Possible values are "q" and "group"}

\item{group_name}{A character string indicating the name of the group, showing as the legend title.}

\item{pt_size}{A numeric value specifying the size of the points.}

\item{line_width}{A numeric value specifying the width of the lines.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{facet_by}{A character string indicating how to facet the data and plots
Possible values are "q" and "group"}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{...}{Additional arguments to pass to \link[iNEXT:iNEXT]{iNEXT::iNEXT} when \code{data} is not an iNEXT object.}
}
\value{
A ggplot object.
}
\description{
This function generates a rarefraction plot for a given dataset.
}
\keyword{internal}
