% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theming.R
\name{element_textbox}
\alias{element_textbox}
\alias{element_grob.element_textbox}
\title{Theme element that add a box to the text}
\usage{
element_textbox(
  family = NULL,
  face = NULL,
  size = NULL,
  colour = NULL,
  fill = NULL,
  box.colour = NULL,
  linetype = NULL,
  linewidth = NULL,
  hjust = NULL,
  vjust = NULL,
  halign = NULL,
  valign = NULL,
  lineheight = NULL,
  margin = NULL,
  padding = NULL,
  width = NULL,
  height = NULL,
  minwidth = NULL,
  maxwidth = NULL,
  minheight = NULL,
  maxheight = NULL,
  r = NULL,
  orientation = NULL,
  color = NULL,
  box.color = NULL,
  debug = FALSE,
  inherit.blank = FALSE
)

\method{element_grob}{element_textbox}(
  element,
  label = "",
  x = NULL,
  y = NULL,
  family = NULL,
  face = NULL,
  colour = NULL,
  size = NULL,
  hjust = NULL,
  vjust = NULL,
  lineheight = NULL,
  margin = NULL,
  ...
)
}
\arguments{
\item{family}{Font family}

\item{face}{Font face}

\item{size}{Font size (in pt)}

\item{colour, color}{Text color}

\item{fill}{Fill color of the enclosing box}

\item{box.colour, box.color}{Line color of the enclosing box (if different from the text color)}

\item{linetype}{Line type of the enclosing box (like \code{lty} in base R)}

\item{linewidth}{Line width of the enclosing box (measured in mm, just like \code{size} in
\code{\link[ggplot2:element]{ggplot2::element_line()}}).}

\item{hjust}{Horizontal justification}

\item{vjust}{Vertical justification}

\item{halign}{Horizontal justification}

\item{valign}{Vertical justification}

\item{lineheight}{Line height, in multiples of the font size}

\item{padding, margin}{Padding and margins around the text box.
See \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}} for details.}

\item{width, height}{Unit objects specifying the width and height
of the textbox, as in \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}}.}

\item{minwidth, minheight, maxwidth, maxheight}{Min and max values for width and height.
Set to NULL to impose neither a minimum nor a maximum.}

\item{r}{Unit value specifying the corner radius of the box}

\item{orientation}{Orientation of the text box. See \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}} for details.}

\item{debug}{Not implemented.}

\item{inherit.blank}{See \code{\link[ggplot2:element]{ggplot2::margin()}} for details.}

\item{element}{A theme element created by \code{\link[=element_textbox]{element_textbox()}}.}

\item{label}{Text to display in the textbox.}

\item{x, y}{Position of the textbox.}

\item{...}{Other arguments passed to \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}}.}
}
\value{
A ggplot2 theme element that can be used inside a \code{\link[ggplot2:theme]{ggplot2::theme()}} call.
}
\description{
Code grabbed from the \code{ggtext} package. See the original code at:
https://github.com/wilkelab/ggtext
This is used to create a text box around the text, primarily to be used in \code{CorPairsPlot}.
}
