% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venndiagram.R
\name{PrepareVennData}
\alias{PrepareVennData}
\alias{VennDiagram}
\title{VennDiagram}
\usage{
PrepareVennData(
  data,
  in_form = NULL,
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL
)

VennDiagram(
  data,
  in_form = NULL,
  split_by = NULL,
  split_by_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  id_by = NULL,
  label = "count",
  label_fg = "black",
  label_size = NULL,
  label_bg = "white",
  label_bg_r = 0.1,
  fill_mode = "count",
  fill_name = NULL,
  palette = ifelse(fill_mode == "set", "Paired", "Spectral"),
  palcolor = NULL,
  alpha = 1,
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame or a list or a VennPlotData object.}

\item{in_form}{A character string indicating the datatype of the input data.
Possible values are "long", "wide", "list", "venn" or NULL.
"long" indicates the data is in long format.
"wide" indicates the data is in wide format.
"list" indicates the data is a list.
"venn" indicates the data is a VennPlotData object.
NULL indicates the function will detect the datatype of the input data.

A long format data would look like:
\preformatted{
group_by id_by
A        a1
A        a2
B        a1
B        a3
...
}

A wide format data would look like:
\preformatted{
A    B
TRUE TRUE
TRUE FALSE
FALSE TRUE
...
}

A list format data would look like:
\preformatted{
list(A = c("a1", "a2"), B = c("a1", "a3"))
}}

\item{group_by}{A character string specifying the column name of the data frame to group the data.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by},
if multiple columns are provided and the in_form is "long".}

\item{id_by}{A character string specifying the column name of the data frame to identify the instances.
Required when \code{group_by} is a single column and data is a data frame.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{label}{A character string specifying the label to show on the Venn diagram.
Possible values are "count", "percent", "both", "none" and a function.
"count" indicates the count of the intersection. "percent" indicates the percentage of the intersection.
"both" indicates both the count and the percentage of the intersection. "none" indicates no label.
If it is a function, if takes a data frame as input and returns a character vector as label.
The data frame has columns "id", "X", "Y", "name", "item" and "count".}

\item{label_fg}{A character string specifying the color of the label text.}

\item{label_size}{A numeric value specifying the size of the label text.}

\item{label_bg}{A character string specifying the background color of the label.}

\item{label_bg_r}{A numeric value specifying the radius of the background of the label.}

\item{fill_mode}{A character string specifying the fill mode of the Venn diagram.
Possible values are "count", "set", "count_rev".
"count" indicates the fill color is based on the count of the intersection.
"set" indicates the fill color is based on the set of the intersection.
"count_rev" indicates the fill color is based on the count of the intersection in reverse order.
The palette will be continuous for "count" and "count_rev". The palette will be discrete for "set".}

\item{fill_name}{A character string to name the legend of colorbar.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A VennPlotData object

A combined ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
\code{PrepareVennData} is helper function to process the input data for Venn diagram.
}
\examples{
\donttest{
set.seed(8525)
data = list(
    A = sort(sample(letters, 8)),
    B = sort(sample(letters, 8)),
    C = sort(sample(letters, 8)),
    D = sort(sample(letters, 8))
)

VennDiagram(data)
VennDiagram(data, fill_mode = "set")
VennDiagram(data, label = "both")
# label with a function
VennDiagram(data, label = function(df) df$name)
VennDiagram(data, palette = "material-indigo", alpha = 0.6)
}
}
