% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityplot.R
\name{RidgePlotAtomic}
\alias{RidgePlotAtomic}
\title{Atomic ridge plot}
\usage{
RidgePlotAtomic(
  data,
  x = NULL,
  in_form = c("long", "wide"),
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  flip = FALSE,
  alpha = 1,
  scale = NULL,
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  x_text_angle = 90,
  keep_empty = FALSE,
  reverse = FALSE,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  aspect.ratio = 1,
  legend.position = "none",
  legend.direction = "vertical",
  ...
)
}
\arguments{
\item{data}{A data frame
It has two forms: wide and long.
For the wide form, the values should under different 'group_by' columns.
For the long form, the values should be under the 'x' column and the 'group_by' column should be provided,
which should be a single column with the group names.}

\item{x}{A character string specifying the column name for the values
A numeric column is expected.
If 'data' is in the wide form, 'x' should be NULL. The values will be taken from the data under 'group_by' columns.}

\item{in_form}{A character string specifying the form of the data. Default is "long".}

\item{group_by}{A character string specifying the column name to group the data
These groups will be shown on the y-axis.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by} if multiple columns are provided
If 'data' is in the wide form, the columns will not be concatenated.}

\item{group_name}{A character string to name the legend of 'group_by', if 'legend.position' is not "none".}

\item{flip}{A logical value. If TRUE, the plot will be flipped.}

\item{alpha}{A numeric value specifying the alpha of the ridges.}

\item{scale}{A numeric value to scale the ridges.
See also \code{\link[ggridges]{geom_density_ridges}}.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{keep_empty}{A logical value. If TRUE, keep the empty groups on the y-axis.}

\item{reverse}{A logical value. If TRUE, reverse the order of the groups on the y-axis.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{...}{Additional arguments.}
}
\description{
Atomic ridge plot
}
\keyword{internal}
