% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chordplot.R
\name{ChordPlotAtomic}
\alias{ChordPlotAtomic}
\title{Atomic chord plot}
\usage{
ChordPlotAtomic(
  data,
  y = NULL,
  from = NULL,
  from_sep = "_",
  to = NULL,
  to_sep = "_",
  flip = FALSE,
  links_color = c("from", "to"),
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  alpha = 0.5,
  labels_rot = FALSE,
  title = NULL,
  subtitle = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string specifying the column name of the data frame to plot for the y-axis.}

\item{from}{A character string of the column name to plot for the source.
A character/factor column is expected.}

\item{from_sep}{A character string to concatenate the columns in \code{from}, if multiple columns are provided.}

\item{to}{A character string of the column name to plot for the target.
A character/factor column is expected.}

\item{to_sep}{A character string to concatenate the columns in \code{to}, if multiple columns are provided.}

\item{flip}{A logical value to flip the source and target.}

\item{links_color}{A character string to specify the color of the links.
Either "from" or "to".}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{labels_rot}{A logical value to rotate the labels by 90 degrees.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{...}{Additional arguments.}
}
\value{
A wrapped element of chord plot
}
\description{
Atomic chord plot
}
\keyword{internal}
