% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WVC.R
\name{WVC_pls}
\alias{WVC_pls}
\title{Weighted Variable Contribution in PLS (WVC-PLS)}
\usage{
WVC_pls(y, X, ncomp, normalize = FALSE, threshold = NULL)
}
\arguments{
\item{y}{Vector of responses.}

\item{X}{Matrix of predictors.}

\item{ncomp}{Number of components.}

\item{normalize}{Divide WVC vectors by maximum value.}

\item{threshold}{Set loading weights smaller than threshold to 0 and recompute component.}
}
\value{
loading weights, loadings, regression coefficients, scores and Y-loadings
plus the WVC weights.
}
\description{
This implements the PLS-WVC2 component dependent version of WVC from Lin et al., i.e.,
using Equations 14, 16 and 19. The 
implementation is used in T. Mehmood, S. Sæbø, K.H. Liland, Comparison of variable selection methods in partial least
squares regression, Journal of Chemometrics 34 (2020) e3226. However, there is a mistake
in the notation in Mehmood et al. exchanging the denominator of Equation 19 (w'X'Xw) with (w'X'Yw).
}
\examples{
library(pls)
data(mayonnaise, package = "pls")
wvc <- WVC_pls(factor(mayonnaise$oil.type), mayonnaise$NIR, 10)
wvcNT <- WVC_pls(factor(mayonnaise$oil.type), mayonnaise$NIR, 10, TRUE, 0.5)
old.par <- par(mfrow=c(3,1), mar=c(2,4,1,1))
matplot(t(mayonnaise$NIR), type='l', col=1, ylab='intensity')
matplot(wvc$W[,1:3], type='l', ylab='W')
matplot(wvcNT$W[,1:3], type='l', ylab='W, thr.=0.5')
par(old.par)

}
\references{
Variable selection in partial least squares with the weighted variable contribution to the first singular value of the covariance matrix,
Weilu Lin, Haifeng Hang, Yingping Zhuang, Siliang Zhang, Chemometrics and Intelligent Laboratory Systems 183 (2018) 113–121.
}
