#' @S3method print plsreg2
print.plsreg2 <-
  function(x, ...)
  {
    cat("\nPLS Regression 2\n")
    cat(rep("-",48), sep="")
    cat("\n$x.scores    ", "X-scores (T-components)")
    cat("\n$x.loads     ", "X-loadings")
    cat("\n$y.scores    ", "Y-scores (U-components)")
    cat("\n$y.loads     ", "Y-loadings")
    cat("\n$cor.xt      ", "X,T correlations")
    cat("\n$cor.yt      ", "Y,T correlations")
    cat("\n$cor.xu      ", "X,U correlations")
    cat("\n$cor.yu      ", "Y,U correlations")
    cat("\n$cor.tu      ", "T,U correlations")
    cat("\n$raw.wgs     ", "raw weights")
    cat("\n$mod.wgs     ", "modified weights")
    cat("\n$std.coefs   ", "standard coefficients")
    cat("\n$reg.coefs   ", "regular coefficients")
    cat("\n$y.pred      ", "Y-predicted")
    cat("\n$resid       ", "residuals")
    cat("\n$expvar      ", "explained variance")
    cat("\n$VIP         ", "variable importance for projection")
    cat("\n$Q2          ", "Q2 index")
    cat("\n$Q2cum       ", "cummulated Q2\n")
    cat(rep("-",48), sep="")
    cat("\n\n")
    invisible(x)
  }
