% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-bases.R
\name{filter_nonzero_bases}
\alias{filter_nonzero_bases}
\title{Filter bases functions}
\usage{
filter_nonzero_bases(bases)
}
\arguments{
\item{bases}{A matrix containing the bases functions.}
}
\value{
A list with the following components:
\item{filtered_bases}{A matrix containing the filtered bases functions, removing those that are essentially zero.}
\item{selected_bases}{A vector containing the indices of the selected bases functions after filtering.}
}
\description{
The \code{filter_nonzero_bases} function filters out bases functions that are essentially zero.
Bases functions with a sum of absolute values less than a threshold (\eqn{10^{-10}}) are considered as essentially zero and are filtered out.
}
\examples{
bases <- matrix(c(0, 0.1, 0.2, 0, 0, 0.3, 0, 0, 0), nrow = 3)
filtered_bases <- filter_nonzero_bases(bases)

}
