% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{summary.gamlasso}
\alias{summary.gamlasso}
\title{Summary for a gamlasso fit}
\usage{
\method{summary}{gamlasso}(object, s = "lambda.min", ...)
}
\arguments{
\item{object}{fitted model object of the class \code{gamlasso} as
produced by \code{gamlasso}}

\item{s}{Value of the lasso penalty parameter \code{lambda} at which
predictions are required. Default is \code{"lambda.min"} but alternatively
\code{"lambda.1se"} can be used.}

\item{...}{Other arguments}
}
\description{
Default sumary method for a \code{gamlasso} object
}
\details{
Outputs a list of two. \code{gam} prints a summary of the
  gam model (the same output as \code{summary(object$gam)}) if it
  is non-null. Objects of the class \code{cv.glmnet} do not have a
  default summary method, so the list item \code{lasso} produces the
  coefficients of the cross-vaidated lasso fit corresponding to the
  lowest value of the \eqn{\lambda} used ( the same output as
  \code{coef(object$cv.glmnet, s = "lambda.min")} if it is non-null).
}
\examples{
library(plsmselect)
library(tidyverse)

data(simData)

## Fit binomial gamlasso model using the term specification
## approach with binomial counts response
## (L2-penalty on linear terms & L1-penalty on smooth terms)
bfit = gamlasso(c("success","failure"),
                linear.terms=paste0("x",1:10),
                smooth.terms=paste0("z",1:4),
                data=simData,
                family = "binomial",
                linear.penalty = "l2",
                smooth.penalty = "l1",
                num.knots = 5,
                seed=1)

## Since the above model has linear.penalty = "l2" it is
## a pure GAM model (i.e. no LASSO component):
bfit$cv.glmnet

## Summary of model (here essentially the same as summary(bfit$gam)
## because there is no LASSO component, i.e. linear.penalty="l2")
summary(bfit)

\donttest{## We could use the formula approach below to fit the same model as above:
simData$X = model.matrix(~x1+x2+x3+x4+x5+x6+x7+x8+x9+x10, data=simData)[,-1]
bfit = gamlasso(cbind(success,failure) ~ X + s(z1, bs="ts") +
                 s(z2, bs="ts") + s(z3, bs="ts") + s(z4, bs="ts"),
                data = simData,
                family = "binomial",
                linear.penalty = "l2",
                smooth.penalty = "l1",
                seed=1)

## For a binary responses we only need one response variable in the formula
bfit2 = gamlasso(Yb ~ X + s(z1, bs="ts") + s(z2, bs="ts") + s(z3, bs="ts") + s(z4, bs="ts"),
                  data = simData,
                  family = "binomial",
                  seed=1)
}
# See ?gamlasso for an example fitting a gaussian response model
# See ?predict.gamlasso for an example fitting a poisson response model
# See ?cumbasehaz for an example fitting a survival response model
}
\seealso{
\code{\link{gamlasso}}, \code{\link[mgcv]{summary.gam}},
  \code{\link[glmnet]{coef.cv.glmnet}}.
}
