% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializer.R
\name{serializer_headers}
\alias{serializer_headers}
\alias{serializer_content_type}
\alias{serializer_octet}
\alias{serializer_csv}
\alias{serializer_tsv}
\alias{serializer_html}
\alias{serializer_json}
\alias{serializer_unboxed_json}
\alias{serializer_geojson}
\alias{serializer_rds}
\alias{serializer_feather}
\alias{serializer_parquet}
\alias{serializer_yaml}
\alias{serializer_text}
\alias{serializer_format}
\alias{serializer_print}
\alias{serializer_cat}
\alias{serializer_write_file}
\alias{serializer_htmlwidget}
\alias{serializer_device}
\alias{serializer_jpeg}
\alias{serializer_png}
\alias{serializer_svg}
\alias{serializer_bmp}
\alias{serializer_tiff}
\alias{serializer_pdf}
\title{Plumber Serializers}
\usage{
serializer_headers(headers = list(), serialize_fn = identity)

serializer_content_type(type, serialize_fn = identity)

serializer_octet(..., type = "application/octet-stream")

serializer_csv(..., type = "text/csv; charset=UTF-8")

serializer_tsv(..., type = "text/tab-separated-values; charset=UTF-8")

serializer_html(type = "text/html; charset=UTF-8")

serializer_json(..., type = "application/json")

serializer_unboxed_json(auto_unbox = TRUE, ..., type = "application/json")

serializer_geojson(..., type = "application/geo+json")

serializer_rds(version = "2", ascii = FALSE, ..., type = "application/rds")

serializer_feather(type = "application/vnd.apache.arrow.file")

serializer_parquet(type = "application/vnd.apache.parquet")

serializer_yaml(..., type = "text/x-yaml; charset=UTF-8")

serializer_text(
  ...,
  serialize_fn = as.character,
  type = "text/plain; charset=UTF-8"
)

serializer_format(..., type = "text/plain; charset=UTF-8")

serializer_print(..., type = "text/plain; charset=UTF-8")

serializer_cat(..., type = "text/plain; charset=UTF-8")

serializer_write_file(type, write_fn, fileext = NULL)

serializer_htmlwidget(..., type = "text/html; charset=UTF-8")

serializer_device(type, dev_on, dev_off = grDevices::dev.off)

serializer_jpeg(..., type = "image/jpeg")

serializer_png(..., type = "image/png")

serializer_svg(..., type = "image/svg+xml")

serializer_bmp(..., type = "image/bmp")

serializer_tiff(..., type = "image/tiff")

serializer_pdf(..., type = "application/pdf")
}
\arguments{
\item{headers}{\code{list()} of headers to add to the response object}

\item{serialize_fn}{Function to serialize the data. The result object will be converted to a character string. Ex: \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}.}

\item{type}{The value to provide for the \code{Content-Type} HTTP header.}

\item{...}{extra arguments supplied to respective internal serialization function.}

\item{auto_unbox}{automatically \code{\link[jsonlite:unbox]{unbox()}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link[jsonlite:unbox]{unbox()}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{\link[=I]{I()}}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}

\item{version}{the workspace format version to use.  \code{NULL}
    specifies the current default version (3). The only other supported
    value is 2, the default from \R 1.4.0 to \R 3.5.0.}

\item{ascii}{a logical.  If \code{TRUE} or \code{NA}, an ASCII
    representation is written; otherwise (default) a binary one.
    See also the comments in the help for \code{\link[base]{save}}.}

\item{write_fn}{Function that should write serialized content to the temp file provided. \code{write_fn} should have the function signature of \code{function(value, tmp_file){}}.}

\item{fileext}{A non-empty character vector giving the file extension. This value will try to be inferred from the content type provided.}

\item{dev_on}{Function to turn on a graphics device.
The graphics device \code{dev_on} function will receive any arguments supplied to the serializer in addition to \code{filename}.
\code{filename} points to the temporary file name that should be used when saving content.}

\item{dev_off}{Function to turn off the graphics device. Defaults to \code{\link[grDevices:dev]{grDevices::dev.off()}}}
}
\description{
Serializers are used in Plumber to transform the R object produced by a
filter/endpoint into an HTTP response that can be returned to the client. See
\href{https://www.rplumber.io/articles/rendering-output.html#serializers-1}{here} for
more details on Plumber serializers and how to customize their behavior.
}
\section{Functions}{
\itemize{
\item \code{serializer_headers}: Add a static list of headers to each return value. Will add \code{Content-Disposition} header if a value is the result of \code{as_attachment()}.

\item \code{serializer_content_type}: Adds a \code{Content-Type} header to the response object

\item \code{serializer_octet}: Octet serializer. If content is received that does
not have a \code{"raw"} type, then an error will be thrown.

\item \code{serializer_csv}: CSV serializer. See also: \code{\link[readr:format_delim]{readr::format_csv()}}

\item \code{serializer_tsv}: TSV serializer. See also: \code{\link[readr:format_delim]{readr::format_tsv()}}

\item \code{serializer_html}: HTML serializer

\item \code{serializer_json}: JSON serializer. See also: \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}

\item \code{serializer_unboxed_json}: JSON serializer with \code{auto_unbox} defaulting to \code{TRUE}. See also: \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}

\item \code{serializer_geojson}: GeoJSON serializer. See also \code{\link[geojsonsf:sf_geojson]{geojsonsf::sf_geojson()}} and [\code{\link[geojsonsf:sfc_geojson]{geojsonsf::sfc_geojson()}}].

\item \code{serializer_rds}: RDS serializer. See also: \code{\link[base:serialize]{base::serialize()}}

\item \code{serializer_feather}: feather serializer. See also: \code{\link[arrow:write_feather]{arrow::write_feather()}}

\item \code{serializer_parquet}: parquet serializer. See also: \code{\link[arrow:write_parquet]{arrow::write_parquet()}}

\item \code{serializer_yaml}: YAML serializer. See also: \code{\link[yaml:as.yaml]{yaml::as.yaml()}}

\item \code{serializer_text}: Text serializer. See also: \code{\link[=as.character]{as.character()}}

\item \code{serializer_format}: Text serializer. See also: \code{\link[=format]{format()}}

\item \code{serializer_print}: Text serializer. Captures the output of \code{\link[=print]{print()}}

\item \code{serializer_cat}: Text serializer. Captures the output of \code{\link[=cat]{cat()}}

\item \code{serializer_write_file}: Write output to a temp file whose contents are read back as a serialized response. \code{serializer_write_file()} creates (and cleans up) a temp file, calls the serializer (which should write to the temp file), and then reads the contents back as the serialized value.  If the content \code{type} starts with \code{"text"}, the return result will be read into a character string, otherwise the result will be returned as a raw vector.

\item \code{serializer_htmlwidget}: htmlwidget serializer. See also: \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget()}}

\item \code{serializer_device}: Helper method to create graphics device serializers, such as \code{\link[=serializer_png]{serializer_png()}}. See also: \code{\link[=endpoint_serializer]{endpoint_serializer()}}

\item \code{serializer_jpeg}: JPEG image serializer. See also: \code{\link[grDevices:png]{grDevices::jpeg()}}

\item \code{serializer_png}: PNG image serializer. See also: \code{\link[grDevices:png]{grDevices::png()}}

\item \code{serializer_svg}: SVG image serializer. See also: \code{\link[grDevices:cairo]{grDevices::svg()}}

\item \code{serializer_bmp}: BMP image serializer. See also: \code{\link[grDevices:png]{grDevices::bmp()}}

\item \code{serializer_tiff}: TIFF image serializer. See also: \code{\link[grDevices:png]{grDevices::tiff()}}

\item \code{serializer_pdf}: PDF image serializer. See also: \code{\link[grDevices:pdf]{grDevices::pdf()}}
}}

