% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformance.R
\name{conformance}
\alias{conformance}
\alias{conformance_alignment}
\alias{variant_state_equation_a_star}
\alias{variant_dijkstra_no_heuristics}
\title{Conformance between an Event Log and a Petri net}
\usage{
conformance_alignment(
  eventlog,
  petrinet,
  initial_marking,
  final_marking,
  parameters = default_parameters(eventlog),
  variant = variant_state_equation_a_star(),
  convert = TRUE
)

variant_state_equation_a_star()

variant_dijkstra_no_heuristics()
}
\arguments{
\item{eventlog}{A bupaR or PM4PY event log.}

\item{petrinet}{A bupaR or PM4PY Petri net.}

\item{initial_marking}{A R vector with the place identifiers of the initial marking or a PM4PY marking.
By default the initial marking of the bupaR Petri net will be used if available.}

\item{final_marking}{A R vector with the place identifiers of the final marking or a PM4PY marking.}

\item{parameters}{PM4PY conformance parameter.
By default the \code{activity_key} from the bupaR event log is specified using \link{param_activity_key}.}

\item{variant}{The conformance variant to be used.}

\item{convert}{\code{TRUE} to automatically convert Python objects to their R equivalent.
If you pass \code{FALSE} you can do manual conversion using the \link[reticulate]{r-py-conversion} function.}
}
\value{
A data frame describing the conformance result.
In case of \code{conformance_alignment} a data frame of log and model moves.
}
\description{
Conformance between an Event Log and a Petri net
}
\examples{
if (pm4py_available()) {
  library(eventdataR)
  data(patients)

  # As Inductive Miner of PM4Py is not life-cycle aware, keep only `complete` events:
  patients_completes <- patients[patients$registration_type == "complete", ]

  # Discover a Petri net
  net <- discovery_inductive(patients_completes)

  # Align event log and Petri net
  a <- conformance_alignment(patients_completes,
                             net$petrinet,
                             net$initial_marking,
                             net$final_marking)

  # Alignment is returned as data frame
  head(a)
}

}
