% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyFilt.R
\name{anova_filter}
\alias{anova_filter}
\title{Identifies biomolecules to be filtered in preparation for IMD-ANOVA.}
\usage{
anova_filter(nonmiss_per_group, min_nonmiss_anova, comparisons = NULL)
}
\arguments{
\item{nonmiss_per_group}{a list of length two. The first element giving the
total number of possible samples for each group. The second element giving
a data.frame with the first column giving the biomolecule identifier and
the second through kth columns giving the number of non-missing
observations for each of the \code{k} groups. Usually the result of
\code{\link{nonmissing_per_group}}}

\item{min_nonmiss_anova}{the minimum number of nonmissing biomolecule values
required, in each group, in order for the biomolecule to not be filtered.
Must be greater than or equal to 2; default value is 2.}

\item{comparisons}{data.frame with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control. If left NULL, then all
pairwise comparisons are executed.}
}
\value{
filter.peps a character vector of the biomolecules to be filtered out
  prior to ANOVA or IMD-ANOVA
}
\description{
The method identifies biomolecules to be filtered specifically according data
requirements for running an ANOVA.
}
\details{
This function filters biomolecules that do not have at least
  \code{min.nonmiss.allowed} values per group, where groups are from
  \code{group_designation}.
}
\seealso{
\code{\link{nonmissing_per_group}}
}
\author{
Kelly Stratton
}
