% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_nmr.R
\name{normalize_nmr}
\alias{normalize_nmr}
\title{Normalize an Object of Class nmrData}
\usage{
normalize_nmr(
  omicsData,
  apply_norm = FALSE,
  backtransform = FALSE,
  metabolite_name = NULL,
  sample_property_cname = NULL
)
}
\arguments{
\item{omicsData}{an object of the class 'nmrData'}

\item{apply_norm}{logical, indicates whether normalization should be applied
to omicsData$e_data. Defaults to FALSE. If TRUE, the normalization is
applied to the data and an S3 object of the same class as \code{omicsData}
(e.g. 'nmrData') with normalized values in \code{e_data} is returned. If
FALSE, the normalization is not applied and an S3 object of the class
\code{nmrnormRes} is returned, allowing some exploratory data analysis
prior to subsequently applying the normalization.}

\item{backtransform}{logical argument indicating if parameters for back
transforming the data, after normalization, should be calculated. Defaults
to FALSE. If TRUE, the parameters for back transforming the data after
normalization will be calculated, and subsequently included in the data
normalization if \code{apply_norm} is TRUE. See details for an explanation 
of how these factors are calculated.}

\item{metabolite_name}{optional character string specifying the name of the
(spiked in) metabolite in \code{e_data} to use for instrument normalization
of the nmrData object. These values will be used to divide the raw
abundance of the corresponding sample in e_data (if e_data is log
transformed, this function accounts for that and returns normalized data on
the same scale it was provided). If using this argument, the
'sample_property_cname' argument should not be specified.}

\item{sample_property_cname}{optional character string specifying the name of
the column in f_data containing information to use for instrument
normalization of the nmrData object, such as a concentration. These values
will be used to divide the raw abundance of the corresponding sample in
e_data (if e_data is log transformed, this function accounts for that by
temporarily un-log transforming the data and then returning normalized data
on the same scale it was provided). If using this argument, the
'metabolite_name' argument should not be specified.}
}
\value{
If \code{apply_norm} is TRUE, an object of class `nmrData`, normalized
 and with information about the normalization process in `nmr_info`.  Otherwise,
 an object of class `nmrnormRes` is returned, with the same info about
 normalization in attribute `nmr_info` to be passed to plotting and summary functions.
}
\description{
The data is normalized either to a spiked-in metabolite or to a
sample-specific property
}
\details{
There are two ways to specify the information needed for
performing instrument normalization on an nmrData object: \enumerate{ \item
specify \code{metabolite_name}. This should be used when normalization to a
spiked in standard is desired. Here \code{metabolite_name} gives the name of
the metabolite in e_data (and e_meta, if present) corresponding to the spiked
in standard. If any samples have a missing value for this metabolite, an
error is returned. \item specify \code{sample_property_cname}. This should be
used when normalizing to a sample property, such as concentration, is
desired. Here, \code{sample_property_cname} gives the name of the column in
\code{f_data} which contains the property to use for normalization. If any
samples have a missing value for this column, and error is returned.}
}
\section{Backtransform}{
 The purpose of back transforming data is to ensure
values are on a scale similar to their raw values before normalization. The
following values are calculated and/or applied for backtransformation
purposes: \tabular{ll}{ If normalization using a metabolite in
\code{e_data} is specified \tab location parameter is the median of the
values for \code{metabolite_name} \cr \tab \cr If normalization using a
sample property in \code{f_data} is specified \tab location parameter is
the median of the values in \code{sample_property} \cr } See examples below.
}

\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)

# Normalize using a metabolite (this is merely an example of how to use this specification;
# the metabolite used was not actually spiked-in for the purpose of normalization)
mynmr <- edata_transform(
  omicsData = nmr_identified_object,
  data_scale = "log2"
)
nmr_norm <- normalize_nmr(
  omicsData = mynmr, apply_norm = TRUE,
  metabolite_name = "unkm1.53",
  backtransform = TRUE
)

# Normalization using a sample property
mynmr <- edata_transform(
  omicsData = nmr_identified_object,
  data_scale = "log2"
)
nmr_norm <- normalize_nmr(
  omicsData = mynmr, apply_norm = TRUE,
  sample_property_cname = "Concentration",
  backtransform = TRUE
)
\dontshow{\}) # examplesIf}
}
