% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots.R
\name{trelli_precheck}
\alias{trelli_precheck}
\title{Performs initial checks for trelliData objects}
\usage{
trelli_precheck(
  trelliData,
  trelliCheck,
  cognostics,
  acceptable_cognostics,
  ggplot_params,
  interactive,
  test_mode,
  test_example,
  single_plot,
  seqDataCheck,
  seqText = NULL,
  p_value_skip = FALSE,
  p_value_thresh = NULL
)
}
\arguments{
\item{trelliData}{trelliData object the user passed to a plotting
function}

\item{trelliCheck}{Check if the object type is supposed to be "omics",
"statRes" or put a vector of both}

\item{cognostics}{A vector of the user provided cognstics}

\item{acceptable_cognostics}{The acceptable cognostics for this plot}

\item{ggplot_params}{The vector of user provided ggplots}

\item{interactive}{The user provided logical for whether the plot should be
interactive}

\item{test_mode}{The user provided logical for whether a smaller trelliscope
should be returned}

\item{test_example}{The user provided vector of plot indices}

\item{single_plot}{The user provided logical for whether a single plot should
be returned}

\item{seqDataCheck}{Whether seqData is permitted for this plot. "no" means that 
seqData cannot be used at all, "permissible" means that seqData can be used, 
and "required" means that seqData is required for the plotting function.}

\item{seqText}{Text that should appear when seqDataCheck is violated.}

\item{p_value_skip}{Whether to skip specific p_value checks.}

\item{p_value_thresh}{The user provided threshold for plotting significant
p-values.}
}
\value{
No return value, validates a trelliData object before passing it to builder functions.
}
\description{
This function runs necessary checks for pmartR trelliscope plotting
functions. It cleans any parameters (rounding numerics to integers, etc.),
and returns them.
}
