% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.hclust.R
\name{pmml.hclust}
\alias{pmml.hclust}
\title{Generate the PMML representation for a hclust object from the package \pkg{amap}.}
\usage{
\method{pmml}{hclust}(model, model_name = "HClust_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Hierarchical Cluster Model", copyright = NULL,
  transforms = NULL, missing_value_replacement = NULL, centers, ...)
}
\arguments{
\item{model}{A hclust object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{centers}{A list of means to represent the clusters.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the hclust object.
}
\description{
Generate the PMML representation for a hclust object from the package \pkg{amap}.
}
\details{
This function converts a hclust object created by the \code{hclusterpar} function
from the \pkg{amap} package.  A \code{hclust} object is a cluster model created
hierarchically. The data is divided recursively until a criteria is met.
This function then takes the final model and represents it as a standard
k-means cluster model. This is possible since while the method of
constructing the model is different, the final model can be represented in
the same way.

To use this pmml function, therefore, one must pick the number of clusters
desired and the coordinate values at those cluster centers. This can be done
using the \code{hclusterpar} and \code{centers.hclust} functions from the
\pkg{amap} and \code{rattle} packages repectively.

The hclust object will be approximated by \code{k} centroids and is
converted into a PMML representation for kmeans clusters.
}
\examples{
\dontrun{

# Cluster the 4 numeric variables of the iris dataset.
library(amap)
library(rattle)

model <- hclusterpar(iris[, -5])

# Get the information about the cluster centers. The last
# parameter of the function used is the number of clusters
# desired.
centerInfo <- centers.hclust(iris[, -5], model, 3)

# Convert to pmml
pmml(model, centers = centerInfo)
}

}
\references{
\href{http://stat.ethz.ch/R-manual/R-devel/library/stats/html/hclust.html}{R project: Hierarchical Clustering}
}
\author{
Graham Williams
}
