% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmpp_predict.R
\name{predict.pmpp}
\alias{predict.pmpp}
\title{Compute forecasts with a PMPP model}
\usage{
\method{predict}{pmpp}(object, fframe = NULL, iter = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{pmpp()}}

\item{fframe}{\code{data.frame} with the same columns as input data
to \code{model}, but with empty rows added to each
cross-sectional unit, as created by \code{create_fframe()}}

\item{iter}{iterating constant, to be used in a loop when extraction
from call is needed}

\item{...}{other arguments passed to the method}
}
\value{
A \code{data.frame} with predicted and true values.
}
\description{
Compute forecasts with a PMPP model
}
\examples{
data(EmplUK, package = "plm")
EmplUK <- dplyr::filter(EmplUK, year \%in\% c(1978, 1979, 1980, 1981, 1982))
pmpp_model <- pmpp(dep_var = "emp", data = EmplUK)
my_fframe <- create_fframe(EmplUK, 1983:1985)
prediction <- predict(pmpp_model, my_fframe)
}
\author{
Michal Oleszak
}
