% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theta.R
\name{get_theta}
\alias{get_theta}
\title{Extract structural model parameter estimates and associated information
from a NONMEM output object.}
\usage{
get_theta(x, output = "est", sigdig = 6, sep = "-")
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the matrix or matrices to be output. Valid flag values are \code{est} (the default),
\code{se}, \code{rse}, \code{95ci}, or \code{all}.}

\item{sigdig}{Specifies the number of significant digits to be provided (default=6).}

\item{sep}{Specifies the separator character to use for 95\% confidence intervals (default="-").}
}
\value{
A named vector of NONMEM model parameter estimates, or in the case of \code{all},
a list of named vectors.

\code{est} returns a vector of THETA values.
\code{se} returns a vector of THETA standard errors.
\code{rse} returns a vector of THETA relative standard errors (se/est*100).
\code{95ci} returns a vector of the asymptotic 95\% confidence intervals for the elements of THETA (est +/- 1.96*se).
\code{all} returns all available THETA information as a list of named vectors.
}
\description{
Extract structural model parameter estimates and associated information
from a NONMEM output object.
}
\examples{
\dontrun{
 nmOutput <- read_nm("run315.xml")
 thetas <- get_theta(nmOutput)
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
